/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.LinkedList;
import java.util.List;
import org.mvel.ExpressionCompiler;
import org.mvel.PropertyAccessException;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier {
    private int start = 0;
    private int cursor = 0;
    private char[] property;
    private int length;
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private List<String> inputs = new LinkedList<String>();

    public PropertyVerifier(char[] property) {
        this.property = property;
        this.length = property.length;
    }

    public PropertyVerifier(String property) {
        this.property = property.toCharArray();
        this.length = this.property.length;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public void analyze() {
        while (this.cursor < this.length) {
            switch (this.nextToken()) {
                case 0: {
                    this.getBeanProperty(this.capture());
                    break;
                }
                case 1: {
                    this.getMethod(this.capture());
                    break;
                }
                case 2: {
                    this.getCollectionProperty(this.capture());
                    break;
                }
            }
        }
    }

    private int nextToken() {
        this.start = this.cursor;
        switch (this.property[this.start]) {
            case '[': {
                return 2;
            }
            case '.': {
                this.cursor = ++this.start;
            }
        }
        while (++this.cursor < this.length && Character.isJavaIdentifierPart(this.property[this.cursor])) {
        }
        if (this.cursor < this.length) {
            switch (this.property[this.cursor]) {
                case '[': {
                    return 2;
                }
                case '(': {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private String capture() {
        return new String(this.property, this.start, this.cursor - this.start);
    }

    private void getBeanProperty(String property) {
    }

    private void whiteSpaceSkip() {
        if (this.cursor < this.length) {
            while (Character.isWhitespace(this.property[this.cursor]) && ++this.cursor < this.length) {
            }
        }
    }

    private boolean scanTo(char c) {
        while (this.cursor < this.length) {
            if (this.property[this.cursor] == c) {
                return true;
            }
            ++this.cursor;
        }
        return false;
    }

    private int containsStringLiteralTermination() {
        int pos = this.cursor;
        --pos;
        while (pos > 0) {
            if (this.property[pos] == '\'' || this.property[pos] == '\"') {
                return pos;
            }
            if (!Character.isWhitespace(this.property[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    private void getCollectionProperty(String prop) {
        String item;
        if (prop.length() > 0) {
            this.getBeanProperty(prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (this.property[this.cursor] == '\'' || this.property[this.cursor] == '\"') {
            ++start;
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            int end = this.containsStringLiteralTermination();
            if (end == -1) {
                throw new PropertyAccessException("unterminated string literal in collections accessor");
            }
            item = new String(this.property, start, end - start);
        } else {
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            item = new String(this.property, start, this.cursor - start);
        }
        ExpressionCompiler compiler = new ExpressionCompiler(item);
        compiler.compile(true);
        ++this.cursor;
    }

    private void getMethod(String name) {
        int st = this.cursor;
        int depth = 1;
        while (this.cursor++ < this.length - 1 && depth != 0) {
            switch (this.property[this.cursor]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
        }
        --this.cursor;
        String tk = this.cursor - st > 1 ? new String(this.property, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() > 0) {
            String[] subtokens;
            String[] stringArray = subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String token = stringArray[n];
                ExpressionCompiler verifCompiler = new ExpressionCompiler(token);
                verifCompiler.compile(true);
                this.inputs.addAll(verifCompiler.getInputs());
                ++n;
            }
        }
    }
}

