/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.CompileException;
import org.mvel.ExpressionParser;
import org.mvel.ForeachContext;
import org.mvel.MVEL;
import org.mvel.Node;
import org.mvel.PropertyAccessor;
import org.mvel.TemplateCompiler;
import org.mvel.TemplateRegistry;
import org.mvel.util.ExecutionStack;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateInterpreter {
    public static boolean cacheAggressively = false;
    private char[] expression;
    private boolean debug = false;
    private Node[] nodes;
    private int node = 0;
    private static final Map<CharSequence, char[]> EX_PRECACHE;
    private static final Map<Object, Node[]> EX_NODE_CACHE;
    private static final Map<Object, Serializable> EX_PRECOMP_CACHE;
    private ExecutionStack stack;

    static {
        if (MVEL.THREAD_SAFE) {
            EX_PRECACHE = Collections.synchronizedMap(new WeakHashMap());
            EX_NODE_CACHE = Collections.synchronizedMap(new WeakHashMap());
            EX_PRECOMP_CACHE = Collections.synchronizedMap(new WeakHashMap());
        } else {
            EX_PRECACHE = new WeakHashMap<CharSequence, char[]>();
            EX_NODE_CACHE = new WeakHashMap<Object, Node[]>();
            EX_PRECOMP_CACHE = new WeakHashMap<Object, Serializable>();
        }
    }

    public static String evalToString(String template, Object ctx) {
        return String.valueOf(TemplateInterpreter.eval(template, ctx));
    }

    public static String evalToString(String template, Map<String, Object> variables) {
        return String.valueOf(TemplateInterpreter.eval(template, variables));
    }

    public static String evalToString(String template, Object ctx, Map variables) {
        return String.valueOf(TemplateInterpreter.eval(template, ctx, variables));
    }

    public static Object eval(String template, Object ctx) {
        if (template == null) {
            return null;
        }
        return new TemplateInterpreter(template).execute(ctx, null);
    }

    public static Object eval(String template, Map<String, Object> variables) {
        return new TemplateInterpreter(template).execute(null, variables);
    }

    public static Object eval(String template, Object ctx, Map variables) {
        if (template == null) {
            return null;
        }
        return new TemplateInterpreter(template).execute(ctx, variables);
    }

    static void configureFactory() {
    }

    public TemplateInterpreter(CharSequence template) {
        if (!EX_PRECACHE.containsKey(template)) {
            this.expression = template.toString().toCharArray();
            EX_PRECACHE.put(template, this.expression);
            this.nodes = new TemplateCompiler(this).compileExpression();
            EX_NODE_CACHE.put(template, (Node[])this.nodes.clone());
        } else {
            this.expression = EX_PRECACHE.get(template);
            try {
                this.nodes = (Node[])EX_NODE_CACHE.get(this.expression).clone();
            }
            catch (NullPointerException e) {
                EX_NODE_CACHE.remove(this.expression);
                this.nodes = new TemplateCompiler(this).compileExpression();
                EX_NODE_CACHE.put(this.expression, (Node[])this.nodes.clone());
            }
        }
        this.cloneAllNodes();
    }

    public TemplateInterpreter(String expression) {
        if (!EX_PRECACHE.containsKey(expression)) {
            this.expression = expression.toCharArray();
            EX_PRECACHE.put(expression, this.expression);
            this.nodes = new TemplateCompiler(this).compileExpression();
            EX_NODE_CACHE.put(expression, (Node[])this.nodes.clone());
        } else {
            this.expression = EX_PRECACHE.get(expression);
            try {
                this.nodes = (Node[])EX_NODE_CACHE.get(expression).clone();
            }
            catch (NullPointerException e) {
                EX_NODE_CACHE.remove(expression);
                this.nodes = new TemplateCompiler(this).compileExpression();
                EX_NODE_CACHE.put(expression, (Node[])this.nodes.clone());
            }
        }
        this.cloneAllNodes();
    }

    private void cloneAllNodes() {
        try {
            int i = 0;
            while (i < this.nodes.length) {
                this.nodes[i] = this.nodes[i].clone();
                ++i;
            }
        }
        catch (Exception e) {
            throw new CompileException("unknown exception", e);
        }
    }

    public TemplateInterpreter(char[] expression) {
        this.expression = expression;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void parseToStream(File template, Object ctx, Map<String, Object> tokens, OutputStream out) throws IOException {
        Object result = TemplateInterpreter.parse(template, ctx, tokens);
        if (result == null) {
            return;
        }
        CharSequence cs = result instanceof CharSequence ? (CharSequence)result : String.valueOf(result);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        int len = cs.length();
        int i = 0;
        while (i < len) {
            writer.write(cs.charAt(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static Object parse(File file, Object ctx, Map<String, Object> tokens) throws IOException {
        return TemplateInterpreter.parse(file, ctx, tokens, null);
    }

    public static Object parse(File file, Object ctx, Map<String, Object> tokens, TemplateRegistry registry) throws IOException {
        if (!file.exists()) {
            throw new CompileException(new StringBuffer("cannot find file: ").append(file.getName()).toString());
        }
        FileInputStream inStream = null;
        FileChannel fc = null;
        try {
            inStream = new FileInputStream(file);
            fc = inStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender sb = new StringAppender((int)file.length());
            int read = 0;
            while (read >= 0) {
                buf.rewind();
                read = fc.read(buf);
                buf.rewind();
                while (read > 0) {
                    sb.append((char)buf.get());
                    --read;
                }
            }
            Object object = TemplateInterpreter.parse(sb, ctx, tokens, registry);
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        return null;
    }

    public static Object parse(CharSequence expression, Object ctx, Map<String, Object> vars) {
        return TemplateInterpreter.parse(expression, ctx, vars, null);
    }

    public static Object parse(CharSequence expression, Object ctx, Map<String, Object> vars, TemplateRegistry registry) {
        if (expression == null) {
            return null;
        }
        return new TemplateInterpreter(expression).execute(ctx, vars, registry);
    }

    public static Object parse(String expression, Object ctx, Map<String, Object> vars) {
        return TemplateInterpreter.parse(expression, ctx, vars, null);
    }

    public static Object parse(String expression, Object ctx, Map<String, Object> vars, TemplateRegistry registry) {
        if (expression == null) {
            return null;
        }
        return new TemplateInterpreter(expression).execute(ctx, vars, registry);
    }

    public Object execute(Object ctx, Map<String, Object> tokens) {
        return this.execute(ctx, tokens, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object execute(Object ctx, Map<String, Object> tokens, TemplateRegistry registry) {
        if (this.nodes == null) {
            return new String(this.expression);
        }
        if (this.nodes.length == 2) {
            switch (this.nodes[0].getToken()) {
                case 5: {
                    if (!TemplateInterpreter.cacheAggressively) {
                        seg = new char[this.expression.length - 3];
                        System.arraycopy(this.expression, 2, seg, 0, seg.length);
                        return MVEL.eval(seg, ctx, tokens);
                    }
                    s = new String(this.expression, 2, this.expression.length - 3);
                    if (!TemplateInterpreter.EX_PRECOMP_CACHE.containsKey(s)) {
                        var5_7 = TemplateInterpreter.EX_PRECOMP_CACHE;
                        synchronized (var5_7) {
                            TemplateInterpreter.EX_PRECOMP_CACHE.put(s, MVEL.compileExpression(s));
                            return MVEL.executeExpression((Object)TemplateInterpreter.EX_PRECOMP_CACHE.get(s), ctx, tokens);
                        }
                    }
                    return MVEL.executeExpression((Object)TemplateInterpreter.EX_PRECOMP_CACHE.get(s), ctx, tokens);
                }
                case 6: {
                    return new String(this.expression);
                }
            }
            return new String(this.expression);
        }
        register = null;
        sbuf = new StringAppender(10);
        currNode = null;
        try {
            oParser = new ExpressionParser(ctx, tokens);
            this.initStack();
            this.pushAndForward();
            block25: while ((currNode = this.pop()) != null) {
                this.node = currNode.getNode();
                switch (currNode.getToken()) {
                    case 6: {
                        register = new String(this.expression, currNode.getStartPos(), currNode.getEndPos() - currNode.getStartPos());
                        sbuf.append(register);
                        ** GOTO lbl134
                    }
                    case 5: {
                        register = oParser.setExpressionArray(this.getInternalSegment(currNode)).parse();
                        sbuf.append(String.valueOf(register));
                        ** GOTO lbl134
                    }
                    case 0: 
                    case 2: {
                        try {
                            if (!((Boolean)oParser.setExpressionArray(this.getInternalSegment(currNode)).parse()).booleanValue()) {
                                this.exitContext();
                            }
                            ** GOTO lbl134
                        }
                        catch (ClassCastException e) {
                            throw new CompileException(new StringBuffer("IF expression does not return a boolean: ").append(new String(this.getSegment(currNode))).toString());
                        }
                    }
                    case 1: {
                        foreachContext = (ForeachContext)currNode.getRegister();
                        if (foreachContext.getItererators() == null) {
                            try {
                                lists = this.getForEachSegment(currNode).split(",");
                                iters = new Iterator[lists.length];
                                i = 0;
                                while (i < lists.length) {
                                    listObject = new ExpressionParser(lists[i], ctx, tokens).parse();
                                    if (listObject instanceof Object[]) {
                                        listObject = Arrays.asList((Object[])listObject);
                                    }
                                    iters[i] = ((Collection)listObject).iterator();
                                    ++i;
                                }
                                foreachContext.setIterators(iters);
                            }
                            catch (ClassCastException e) {
                                throw new CompileException(new StringBuffer("expression for collections does not return a collections object: ").append(new String(this.getSegment(currNode))).toString());
                            }
                            catch (NullPointerException e) {
                                throw new CompileException(new StringBuffer("null returned for foreach in expression: ").append(this.getForEachSegment(currNode)).toString());
                            }
                        }
                        iters = foreachContext.getItererators();
                        alias = currNode.getAlias().split(",");
                        i = 0;
                        while (i < alias.length) {
                            alias[i] = alias[i].trim();
                            ++i;
                        }
                        if (iters[0].hasNext()) {
                            this.push();
                            i = 0;
                            while (i < iters.length) {
                                tokens.put(alias[i], iters[i].next());
                                ++i;
                            }
                            if (foreachContext.getCount() != 0) {
                                sbuf.append(foreachContext.getSeperator());
                            }
                            tokens.put("i0", new Integer(foreachContext.getCount()));
                            foreachContext.setCount(foreachContext.getCount() + 1);
                        } else {
                            i = 0;
                            while (i < iters.length) {
                                tokens.remove(alias[i]);
                                ++i;
                            }
                            foreachContext.setIterators(null);
                            foreachContext.setCount(0);
                            this.exitContext();
                        }
                        ** GOTO lbl134
                    }
                    case 3: 
                    case 4: {
                        if (!this.stack.isEmpty()) continue block25;
                        this.forwardAndPush();
                        break;
                    }
                    case 8: {
                        this.pushNode(currNode.getEndNode());
                        break;
                    }
                    case 7: {
                        if (this.nodes.length == 2) {
                            return register;
                        }
                        return sbuf.toString();
                    }
                    case 10: {
                        includeRef = (TemplateCompiler.IncludeRef)this.nodes[this.node].getRegister();
                        params = includeRef.getParams();
                        vars = new HashMap<String, Object>(params.length * 2);
                        var14_25 = params;
                        var12_23 = 0;
                        var13_24 = var14_25.length;
                        while (var12_23 < var13_24) {
                            param = var14_25[var12_23];
                            vars.put(param.getIdentifier(), MVEL.eval(param.getValue(), ctx, tokens));
                            ++var12_23;
                        }
                        if (registry == null) {
                            throw new CompileException(new StringBuffer("No TemplateRegistry specified, cannot load template='").append(includeRef.getName()).append("'").toString());
                        }
                        template = registry.getTemplate(includeRef.getName());
                        if (template == null) {
                            throw new CompileException(new StringBuffer("Template does not exist in the TemplateRegistry, cannot load template='").append(includeRef.getName()).append("'").toString());
                        }
                        sbuf.append(TemplateInterpreter.parse(template, ctx, vars, registry));
                    }
lbl134:
                    // 7 sources

                    default: {
                        this.forwardAndPush();
                    }
                }
            }
            throw new CompileException("expression did not end properly: expected TERMINUS node");
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            if (currNode != null) {
                throw new CompileException(new StringBuffer("problem encountered at node [").append(currNode.getNode()).append("] ").append(currNode.getToken()).append("{").append(currNode.getStartPos()).append(",").append(currNode.getEndPos()).append("}").toString(), e);
            }
            throw new CompileException(new StringBuffer("unhandled fatal exception (node:").append(this.node).append(")").toString(), e);
        }
    }

    private void initStack() {
        this.stack = new ExecutionStack();
    }

    private void push() {
        this.push(this.nodes[this.node]);
    }

    private void push(Node node) {
        if (node == null) {
            return;
        }
        this.stack.push(node);
    }

    private void pushNode(int i) {
        this.stack.push(this.nodes[i]);
    }

    private void exitContext() {
        this.node = this.nodes[this.node].getEndNode() - 1;
    }

    public void forwardAndPush() {
        ++this.node;
        this.push();
    }

    private void pushAndForward() {
        this.push();
        ++this.node;
    }

    private Node pop() {
        return (Node)this.stack.pop();
    }

    public static Object getValuePE(String expression, Object ctx, Map<String, Object> tokens) {
        return new TemplateInterpreter(expression).execute(ctx, tokens);
    }

    public static void setValuePE(String expression, Object ctx, Object preParseCx, Object value) {
        PropertyAccessor.set(ctx, String.valueOf(TemplateInterpreter.eval(expression, preParseCx)), value);
    }

    public char[] getExpression() {
        return this.expression;
    }

    public void setExpression(char[] expression) {
        this.expression = expression;
    }

    private char[] getSegment(Node n) {
        char[] ca = new char[n.getLength()];
        System.arraycopy(this.expression, n.getStartPos(), ca, 0, ca.length);
        return ca;
    }

    private char[] getInternalSegment(Node n) {
        int start = n.getStartPos();
        int depth = 1;
        while (this.expression[start++] != '{') {
        }
        int end = start;
        while (depth > 0) {
            switch (this.expression[++end]) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                }
            }
        }
        char[] ca = new char[end - start];
        System.arraycopy(this.expression, start, ca, 0, ca.length);
        return ca;
    }

    private String getForEachSegment(Node n) {
        if (n.getAlias() == null) {
            return new String(this.getInternalSegment(n));
        }
        return n.getName();
    }

    public static boolean isCacheAggressively() {
        return cacheAggressively;
    }

    public static void setCacheAggressively(boolean cacheAggressively) {
        TemplateInterpreter.cacheAggressively = cacheAggressively;
    }
}

