/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import org.mvel.AbstractParser;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.EndWithValue;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.PropertyAccessor;
import org.mvel.UnresolveablePropertyException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizationNotSupported;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class Token
implements Cloneable,
Serializable {
    public static final int LITERAL = 1;
    public static final int DEEP_PROPERTY = 2;
    public static final int OPERATOR = 4;
    public static final int IDENTIFIER = 8;
    public static final int SUBEVAL = 16;
    public static final int NUMERIC = 32;
    public static final int NEGATION = 64;
    public static final int INVERT = 256;
    public static final int FOLD = 512;
    public static final int ASSIGN = 4096;
    public static final int LOOKAHEAD = 8192;
    public static final int COLLECTION = 16384;
    public static final int NEW = 32768;
    public static final int CAPTURE_ONLY = 65536;
    public static final int THISREF = 131072;
    public static final int INLINE_COLLECTION = 262144;
    public static final int NOCOMPILE = 524288;
    public static final int STR_LITERAL = 0x100000;
    public static final int PUSH = 0x200000;
    public static final int BLOCK = 0x400000;
    public static final int BLOCK_IF = 0x800000;
    public static final int BLOCK_FOREACH = 0x1000000;
    public static final int RETURN = Integer.MIN_VALUE;
    protected int firstUnion;
    protected int endOfName;
    protected int fields = 0;
    protected char[] name;
    protected String nameCache;
    protected Object literal;
    protected Accessor accessor;
    public Token nextToken;

    public Token(char[] expr, int start, int end, int fields) {
        this.fields = fields;
        if ((fields & Integer.MIN_VALUE) != 0) {
            this.fields |= 4;
            this.literal = new Integer(99);
        }
        char[] name = new char[end - start];
        System.arraycopy(expr, start, name, 0, end - start);
        this.setName(name);
    }

    public Token(char[] expr, int fields) {
        this.fields = fields;
        this.name = expr;
    }

    public Token(int fields, Object literalValue) {
        this.fields = fields;
        this.literal = literalValue;
    }

    private String getAbsoluteRootElement() {
        if ((this.fields & 0x4002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return null;
    }

    private String getAbsoluteRemainder() {
        return (this.fields & 0x4000) != 0 ? new String(this.name, this.endOfName, this.name.length - this.endOfName) : ((this.fields & 2) != 0 ? new String(this.name, this.firstUnion + 1, this.name.length - this.firstUnion - 1) : null);
    }

    public char[] getNameAsArray() {
        return this.name;
    }

    private int getAbsoluteFirstPart() {
        if ((this.fields & 0x4000) != 0) {
            if (this.firstUnion < 0 || this.endOfName < this.firstUnion) {
                return this.endOfName;
            }
            return this.firstUnion;
        }
        if ((this.fields & 2) != 0) {
            return this.firstUnion;
        }
        return -1;
    }

    public String getAbsoluteName() {
        if ((this.fields & 0x4002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return this.getName();
    }

    public String getName() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        if (this.name != null) {
            this.nameCache = new String(this.name);
            return this.nameCache;
        }
        return "";
    }

    public Object getLiteralValue() {
        return this.literal;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 1) != 0) {
            if ((this.fields & 0x20000) != 0) {
                return thisValue;
            }
            return this.literal;
        }
        try {
            return this.valRet(this.accessor.getValue(ctx, thisValue, factory));
        }
        catch (NullPointerException e) {
            AccessorOptimizer optimizer;
            Object retVal = null;
            if ((this.fields & 0x1000) != 0) {
                optimizer = OptimizerFactory.getDefaultAccessorCompiler();
                this.accessor = optimizer.optimizeAssignment(this.name, ctx, thisValue, factory);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else if ((this.fields & 0x10) != 0) {
                optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                this.accessor = (ExecutableStatement)MVEL.compileExpression(this.name);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else if ((this.fields & 0x40000) != 0) {
                optimizer = OptimizerFactory.getDefaultAccessorCompiler();
                this.accessor = optimizer.optimizeCollection(this.name, ctx, thisValue, factory);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else if ((this.fields & 0x200) != 0) {
                optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                this.accessor = optimizer.optimizeFold(this.name, ctx, thisValue, factory);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else if ((this.fields & 0x8000) != 0) {
                optimizer = OptimizerFactory.getDefaultAccessorCompiler();
                this.accessor = optimizer.optimizeObjectCreation(this.name, ctx, thisValue, factory);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else {
                if ((this.fields & Integer.MIN_VALUE) != 0) {
                    AccessorOptimizer optimizer2 = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                    this.accessor = optimizer2.optimizeReturn(this.name, ctx, thisValue, factory);
                    throw new EndWithValue(optimizer2.getResultOptPass());
                }
                try {
                    optimizer = OptimizerFactory.getDefaultAccessorCompiler();
                    this.accessor = optimizer.optimize(this.name, ctx, thisValue, factory, true);
                }
                catch (OptimizationNotSupported ne) {
                    optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                    this.accessor = optimizer.optimize(this.name, ctx, thisValue, factory, true);
                }
            }
            if (this.accessor == null) {
                throw new OptimizationFailure("failed optimization", e);
            }
            if (retVal == null) {
                retVal = optimizer.getResultOptPass();
            }
            return this.valRet(retVal);
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 1) != 0) {
            if ((this.fields & 0x20000) != 0) {
                return thisValue;
            }
            return this.literal;
        }
        if ((this.fields & 0x1000) != 0) {
            if (this.accessor == null) {
                this.accessor = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE).optimizeAssignment(this.name, ctx, thisValue, factory);
            }
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        if ((this.fields & 0x10) != 0) {
            return this.valRet(MVEL.eval(this.name, ctx, factory));
        }
        if ((this.fields & 0x40000) != 0) {
            if (this.accessor == null) {
                this.accessor = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE).optimizeCollection(this.name, ctx, thisValue, factory);
            }
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        if ((this.fields & 0x200) != 0) {
            if (this.accessor == null) {
                AccessorOptimizer optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                this.accessor = optimizer.optimizeFold(this.name, ctx, thisValue, factory);
                return optimizer.getResultOptPass();
            }
        } else if ((this.fields & 0x8000) != 0) {
            if (this.accessor == null) {
                AccessorOptimizer optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                this.accessor = optimizer.optimizeObjectCreation(this.name, ctx, thisValue, factory);
                return optimizer.getResultOptPass();
            }
        } else if ((this.fields & Integer.MIN_VALUE) != 0) {
            AccessorOptimizer optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
            this.accessor = optimizer.optimizeReturn(this.name, ctx, thisValue, factory);
            throw new EndWithValue(optimizer.getResultOptPass());
        }
        if ((this.fields & 2) != 0) {
            String s = this.getAbsoluteRootElement();
            if (AbstractParser.LITERALS.containsKey(s)) {
                Class<?> clazz;
                Object literal = AbstractParser.LITERALS.get(s);
                try {
                    clazz = Class.forName("org.mvel.util.ThisLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (literal == clazz) {
                    literal = thisValue;
                }
                return this.valRet(PropertyAccessor.get(this.getAbsoluteRemainder(), literal, factory, thisValue));
            }
            if (factory != null && factory.isResolveable(s)) {
                return this.valRet(PropertyAccessor.get(this.getAbsoluteRemainder(), factory.getVariableResolver(s).getValue(), factory, thisValue));
            }
            if (ctx != null) {
                try {
                    return this.valRet(PropertyAccessor.get(this.name, ctx, factory, thisValue));
                }
                catch (PropertyAccessException e) {
                    Object sa = this.tryStaticAccess(ctx, factory);
                    if (sa == null) {
                        throw e;
                    }
                    return this.valRet(sa);
                }
            }
        } else {
            String s;
            if (factory != null && factory.isResolveable(s = this.getAbsoluteName())) {
                if (this.isCollection()) {
                    return this.valRet(PropertyAccessor.get(new String(this.name, this.endOfName, this.name.length - this.endOfName), factory.getVariableResolver(s).getValue(), factory, thisValue));
                }
                return this.valRet(factory.getVariableResolver(s).getValue());
            }
            if (ctx != null) {
                try {
                    return this.valRet(PropertyAccessor.get(this.name, ctx, factory, thisValue));
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new UnresolveablePropertyException(this);
                }
            }
            throw new UnresolveablePropertyException(this);
        }
        return null;
    }

    private Object valRet(Object value) {
        if ((this.fields & 0x40) != 0) {
            try {
                return new Boolean((Boolean)value == false);
            }
            catch (Exception e) {
                throw new CompileException("illegal negation of non-boolean value");
            }
        }
        if ((this.fields & 0x100) != 0) {
            try {
                return new Integer(~((Integer)value).intValue());
            }
            catch (Exception e) {
                throw new CompileException("bitwise (~) operator can only be applied to integers");
            }
        }
        return value;
    }

    private Object tryStaticAccess(Object thisRef, VariableResolverFactory factory) {
        try {
            boolean meth = false;
            int depth = 0;
            int last = this.name.length;
            int i = last - 1;
            while (i > 0) {
                switch (this.name[i]) {
                    case '.': {
                        if (!meth) {
                            try {
                                return PropertyAccessor.get(new String(this.name, last, this.name.length - last), Class.forName(new String(this.name, 0, last)), factory, thisRef);
                            }
                            catch (ClassNotFoundException e) {
                                return PropertyAccessor.get(new String(this.name, i + 1, this.name.length - i - 1), Class.forName(new String(this.name, 0, i)), factory, thisRef);
                            }
                        }
                        meth = false;
                        last = i;
                        break;
                    }
                    case ')': {
                        if (depth++ != 0) break;
                        meth = true;
                        break;
                    }
                    case '(': {
                        --depth;
                    }
                }
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setName(char[] name) {
        if ((this.fields & Integer.MIN_VALUE) != 0) {
            this.name = name;
            return;
        }
        if ((this.fields & 0x100000) != 0) {
            this.fields |= 1;
            int escapes = 0;
            int i = 0;
            while (i < name.length) {
                if (name[i] == '\\') {
                    name[i++] = '\u0000';
                    name[i] = ParseTools.handleEscapeSequence(name[i]);
                    ++escapes;
                }
                ++i;
            }
            char[] processedEscapeString = new char[name.length - escapes];
            int cursor = 0;
            char[] cArray = name;
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                char aName = cArray[n];
                if (aName != '\u0000') {
                    processedEscapeString[cursor++] = aName;
                }
                ++n;
            }
            this.name = processedEscapeString;
            this.literal = new String(processedEscapeString);
        } else {
            this.name = name;
            this.literal = new String(name);
        }
        if ((this.fields & 0x11) == 0) {
            if (AbstractParser.LITERALS.containsKey(this.literal)) {
                Class<?> clazz;
                this.fields |= 1;
                this.literal = AbstractParser.LITERALS.get(this.literal);
                try {
                    clazz = Class.forName("org.mvel.util.ThisLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (this.literal == clazz) {
                    this.fields |= 0x20000;
                }
            } else {
                if (AbstractParser.OPERATORS.containsKey(this.literal)) {
                    this.fields |= 4;
                    this.literal = AbstractParser.OPERATORS.get(this.literal);
                    return;
                }
                if (PropertyTools.isNumber(name)) {
                    this.fields |= 0x21;
                    this.literal = PropertyTools.handleNumericConversion(name);
                    if ((this.fields & 0x100) != 0) {
                        try {
                            this.literal = new Integer(~((Integer)this.literal).intValue());
                        }
                        catch (ClassCastException e) {
                            throw new CompileException("bitwise (~) operator can only be applied to integers");
                        }
                    }
                    return;
                }
                this.firstUnion = ArrayTools.findFirst('.', name);
                this.fields = this.firstUnion > 0 ? (this.fields |= 0xA) : (this.fields |= 8);
            }
        }
        if ((this.endOfName = ArrayTools.findFirst('[', name)) > 0) {
            this.fields |= 0x4000;
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public boolean isIdentifier() {
        return (this.fields & 8) != 0;
    }

    public boolean isSubeval() {
        return (this.fields & 0x10) != 0;
    }

    public boolean isLiteral() {
        return (this.fields & 1) != 0;
    }

    public boolean isThisVal() {
        return (this.fields & 0x20000) != 0;
    }

    public boolean isOperator() {
        return (this.fields & 4) != 0;
    }

    public boolean isOperator(Integer operator) {
        return (this.fields & 4) != 0 && operator.equals(this.literal);
    }

    public Integer getOperator() {
        return (Integer)this.literal;
    }

    private boolean isCollection() {
        return (this.fields & 0x4000) != 0;
    }

    public boolean isNewObject() {
        return (this.fields & 0x8000) != 0;
    }

    public boolean isAssignment() {
        return (this.fields & 0x1000) != 0;
    }
}

