/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class CharCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        CNV = new HashMap<Class, Converter>();
        try {
            clazz3 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz3, new Converter(){

            public Object convert(Object o) {
                if (((String)o).length() > 0) {
                    throw new ConversionException("cannot convert a string with a length greater than 1 to java.lang.Character");
                }
                return new Character(((String)o).charAt(0));
            }
        });
        try {
            clazz2 = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz2, new Converter(){

            public Object convert(Object o) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return ((Converter)CNV.get(clazz)).convert(String.valueOf(o));
            }
        });
        try {
            clazz = Class.forName("java.lang.Character");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz, new Converter(){

            public Object convert(Object o) {
                return new Character(((Character)o).charValue());
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + clazz.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

