/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class IntegerCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        CNV = new HashMap<Class, Converter>(10);
        try {
            clazz10 = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz10, new Converter(){

            public Object convert(Object o) {
                if (((String)o).length() == 0) {
                    return new Integer(0);
                }
                return new Integer(Integer.parseInt(String.valueOf(o)));
            }
        });
        try {
            clazz9 = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz9, new Converter(){

            public Integer convert(Object o) {
                return new Integer(((BigDecimal)o).intValue());
            }
        });
        try {
            clazz8 = Class.forName("java.math.BigInteger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz8, new Converter(){

            public Integer convert(Object o) {
                return new Integer(((BigInteger)o).intValue());
            }
        });
        try {
            clazz7 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz7, new Converter(){

            public Object convert(Object o) {
                return new Integer(Integer.parseInt((String)o));
            }
        });
        try {
            clazz6 = Class.forName("java.lang.Short");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz6, new Converter(){

            public Object convert(Object o) {
                return new Float(((Short)o).floatValue());
            }
        });
        try {
            clazz5 = Class.forName("java.lang.Long");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz5, new Converter(){

            public Object convert(Object o) {
                if ((Long)o > Integer.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Integer(((Long)o).intValue());
            }
        });
        try {
            clazz4 = Class.forName("java.lang.Float");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz4, new Converter(){

            public Object convert(Object o) {
                if (((Float)o).floatValue() > 2.1474836E9f) {
                    throw new ConversionException("cannot coerce Float to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Integer(((Float)o).intValue());
            }
        });
        try {
            clazz3 = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz3, new Converter(){

            public Object convert(Object o) {
                if ((Double)o > 2.147483647E9) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Integer(((Double)o).intValue());
            }
        });
        try {
            clazz2 = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz2, new Converter(){

            public Object convert(Object o) {
                return o;
            }
        });
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz, new Converter(){

            public Integer convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + clazz.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

