/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.Map;
import org.mvel.integration.VariableResolver;

public class MapVariableResolver
implements VariableResolver {
    private String name;
    private Class knownType;
    private Map variableMap;

    public MapVariableResolver(Map variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKnownType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map variableMap) {
        this.variableMap = variableMap;
    }

    public String getName() {
        return this.name;
    }

    public Class getKnownType() {
        if (this.knownType == null && this.variableMap.containsKey(this.name)) {
            Class<?> clazz;
            if (this.variableMap.get(this.name) != null) {
                clazz = this.variableMap.get(this.name).getClass();
            } else {
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.knownType = clazz;
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.knownType = clazz;
        }
        return this.knownType;
    }

    public void setValue(Object value) {
        this.variableMap.put(this.name, value);
    }

    public Object getValue() {
        return this.variableMap.get(this.name);
    }

    public int getFlags() {
        return 0;
    }
}

