/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.HashMap;
import java.util.Map;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolverFactory
implements VariableResolverFactory {
    private Map<String, Object> variables;
    private Map<String, VariableResolver> variableResolvers;
    private VariableResolverFactory nextFactory;

    public MapVariableResolverFactory(Map<String, Object> variables) {
        this.variables = variables;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory != null && this.nextFactory.isResolveable(name)) {
            VariableResolver vr = this.nextFactory.getVariableResolver(name);
            vr.setValue(value);
            return vr;
        }
        this.variables.put(name, value);
        return new MapVariableResolver(this.variables, name);
    }

    @Override
    public VariableResolverFactory getNextFactory() {
        return this.nextFactory;
    }

    @Override
    public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
        this.nextFactory = resolverFactory;
        return this.nextFactory;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.isResolveable(name)) {
            if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
                return this.variableResolvers.get(name);
            }
            return this.nextFactory.getVariableResolver(name);
        }
        return null;
    }

    @Override
    public boolean isResolveable(String name) {
        if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
            return true;
        }
        if (this.variables != null && this.variables.containsKey(name)) {
            if (this.variableResolvers == null) {
                this.variableResolvers = new HashMap<String, VariableResolver>();
            }
            this.variableResolvers.put(name, new MapVariableResolver(this.variables, name));
            return true;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.isResolveable(name);
        }
        return false;
    }

    public void pack() {
        if (this.variables != null) {
            if (this.variableResolvers == null) {
                this.variableResolvers = new HashMap<String, VariableResolver>();
            }
            for (String s : this.variables.keySet()) {
                this.variableResolvers.put(s, new MapVariableResolver(this.variables, s));
            }
        }
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }
}

