/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers;

import java.util.HashMap;
import java.util.Map;
import org.mvel.CompileException;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.Optimizer;
import org.mvel.optimizers.impl.asm.ASMAccessorOptimizer;
import org.mvel.optimizers.impl.asm.ASMOptimizer;
import org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer;

public class OptimizerFactory {
    public static String SAFE_REFLECTIVE = "Reflective";
    private static String defaultOptimizer;
    private static final Map<String, Optimizer> optimizers;
    private static final Map<String, AccessorOptimizer> accessorCompilers;

    static {
        optimizers = new HashMap<String, Optimizer>();
        accessorCompilers = new HashMap<String, AccessorOptimizer>();
        accessorCompilers.put(SAFE_REFLECTIVE, new ReflectiveAccessorOptimizer());
        try {
            Class.forName("org.mvel.asm.ClassWriter");
            defaultOptimizer = "ASM";
            optimizers.put("ASM", new ASMOptimizer());
            accessorCompilers.put("ASM", new ASMAccessorOptimizer());
        }
        catch (ClassNotFoundException e) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("[MVEL] Notice: Possible incorrect version of ASM present (3.0 required).  Disabling JIT compiler.  Reflective Optimizer will be used.");
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        if (Boolean.getBoolean("mvel.disable.jit")) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
    }

    public static void registerOptimizer(Optimizer optimizer) {
        optimizers.put(optimizer.getName(), optimizer);
    }

    public static Optimizer getDefaultOptimizer() {
        return optimizers.get(defaultOptimizer);
    }

    public static AccessorOptimizer getDefaultAccessorCompiler() {
        try {
            return (AccessorOptimizer)accessorCompilers.get(defaultOptimizer).getClass().newInstance();
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }

    public static AccessorOptimizer getAccessorCompiler(String name) {
        try {
            return (AccessorOptimizer)accessorCompilers.get(name).getClass().newInstance();
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }
}

