/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.Token;
import org.mvel.asm.ClassWriter;
import org.mvel.asm.FieldVisitor;
import org.mvel.asm.MethodVisitor;
import org.mvel.asm.Type;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizationNotSupported;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private static final String MAP_IMPL = "java/util/HashMap";
    private static final String LIST_IMPL = "org/mvel/util/FastList";
    private static final int OPCODES_VERSION;
    private Object ctx;
    private Object thisRef;
    private VariableResolverFactory variableFactory;
    private static final Object[] EMPTYARG;
    private boolean first = true;
    private String className;
    private ClassWriter cw;
    private MethodVisitor mv;
    private Object val;
    private int stacksize = 1;
    private long time;
    private int inputs;
    private ArrayList<ExecutableStatement> compiledInputs;
    private Class returnType;
    private static final Method defineClass;
    private int cnum = 3;
    private int lastCnum = 0;
    private static final int ARRAY = 0;
    private static final int LIST = 1;
    private static final int MAP = 2;
    private static final int VAL = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.optimizers.impl.asm.ASMAccessorOptimizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        String javaVersion = System.getProperty("java.version");
        OPCODES_VERSION = javaVersion.startsWith("1.4") ? 48 : (javaVersion.startsWith("1.5") ? 49 : (javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7") ? 50 : 46));
        EMPTYARG = new Object[0];
        try {
            Class<?> clazz2;
            Class<?> clazz3;
            Class[] classArray = new Class[4];
            try {
                clazz3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz3;
            try {
                clazz2 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[1] = clazz2;
            classArray[2] = Integer.TYPE;
            classArray[3] = Integer.TYPE;
            defineClass = Class.forName("java.lang.ClassLoader").getDeclaredMethod("defineClass", classArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ASMAccessorOptimizer() {
        new ClassWriter(1);
    }

    private void _initJIT() {
        this.cw = new ClassWriter(3);
        this.className = new StringBuffer("ASMAccessorImpl_").append(String.valueOf(this.cw.hashCode()).replaceAll("\\-", "_")).append(System.currentTimeMillis() / 1000L).toString();
        this.cw.visit(OPCODES_VERSION, 33, this.className, null, "java/lang/Object", new String[]{"org/mvel/Accessor"});
        MethodVisitor m = this.cw.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        m.visitInsn(177);
        m.visitMaxs(1, 1);
        m.visitEnd();
        this.mv = this.cw.visitMethod(1, "getValue", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
    }

    @Override
    public Accessor optimize(char[] property, Object staticContext, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.time = System.currentTimeMillis();
        this.inputs = 0;
        this.compiledInputs = new ArrayList();
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.val = null;
        this.length = property.length;
        this.expr = property;
        this.ctx = staticContext;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this._initJIT();
        return this.compileAccessor();
    }

    private void _finishJIT() {
        if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        if (this.returnType == Void.TYPE) {
            ASMAccessorOptimizer.debug("ACONST_NULL");
            this.mv.visitInsn(1);
        }
        ASMAccessorOptimizer.debug("ARETURN");
        this.mv.visitInsn(176);
        ASMAccessorOptimizer.debug(new StringBuffer("\n{METHOD STATS (maxstack=").append(this.stacksize).append(")}\n").toString());
        this.mv.visitMaxs(this.stacksize, 1);
        this.mv.visitEnd();
        this.buildInputs();
        this.cw.visitEnd();
    }

    private Accessor _initializeAccessor() throws Exception {
        Object o;
        Class cls = ASMAccessorOptimizer.loadClass(this.className, this.cw.toByteArray());
        ASMAccessorOptimizer.debug(new StringBuffer("[MVEL JIT Completed Optimization <<").append(new String(this.expr)).append(">>]::").append(cls).append(" (time: ").append(System.currentTimeMillis() - this.time).append("ms)").toString());
        if (this.inputs == 0) {
            o = cls.newInstance();
        } else {
            Class[] parms = new Class[this.inputs];
            int i = 0;
            while (i < this.inputs) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.mvel.ExecutableStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                parms[i] = clazz;
                ++i;
            }
            o = cls.getConstructor(parms).newInstance(this.compiledInputs.toArray(new ExecutableStatement[this.compiledInputs.size()]));
        }
        if (!(o instanceof Accessor)) {
            throw new RuntimeException("Classloader problem detected. JIT Class is not subclass of org.mvel.Accessor.");
        }
        return (Accessor)o;
    }

    private Accessor compileAccessor() {
        ASMAccessorOptimizer.debug(new StringBuffer("\n{Initiate Compile: ").append(new String(this.expr)).append("}\n").toString());
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                    }
                }
                this.first = false;
            }
            this.val = curr;
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new StringBuffer("array or collections index out of bounds (property: ").append(new String(this.expr)).append(")").toString(), e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException(new StringBuffer("failed to access property: <<").append(new String(this.expr)).append(">> in: ").append(this.ctx != null ? this.ctx.getClass() : null).toString(), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new StringBuffer("null pointer exception in property: ").append(new String(this.expr)).toString(), e);
        }
        catch (OptimizationNotSupported e) {
            throw e;
        }
        catch (Exception e) {
            throw new PropertyAccessException(new StringBuffer("unknown exception in expression: ").append(new String(this.expr)).toString(), e);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        ASMAccessorOptimizer.debug(new StringBuffer("{bean: ").append(property).append("}").toString());
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(property)) {
            try {
                ASMAccessorOptimizer.debug("ALOAD 3");
                this.mv.visitVarInsn(25, 3);
                ASMAccessorOptimizer.debug(new StringBuffer("LDC :").append(property).toString());
                this.mv.visitLdcInsn(property);
                ASMAccessorOptimizer.debug("INVOKEINTERFACE org/mvel/integration/VariableResolverFactory.getVariableResolver");
                this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolverFactory", "getVariableResolver", "(Ljava/lang/String;)Lorg/mvel/integration/VariableResolver;");
                ASMAccessorOptimizer.debug("INVOKEINTERFACE org/mvel/integration/VariableResolver.getValue");
                this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolver", "getValue", "()Ljava/lang/Object;");
            }
            catch (Exception e) {
                throw new OptimizationFailure("critical error in JIT", e);
            }
            return this.variableFactory.getVariableResolver(property).getValue();
        }
        if (member instanceof Field) {
            Object o = ((Field)member).get(ctx);
            if (this.first) {
                ASMAccessorOptimizer.debug("ALOAD 2");
                this.mv.visitVarInsn(25, 2);
            }
            if ((member.getModifiers() & 8) != 0) {
                ASMAccessorOptimizer.debug(new StringBuffer("GETSTATIC ").append(Type.getDescriptor(member.getDeclaringClass())).append(".").append(member.getName()).append("::").append(Type.getDescriptor(((Field)member).getType())).toString());
                this.returnType = ((Field)member).getType();
                this.mv.visitFieldInsn(178, Type.getDescriptor(member.getDeclaringClass()), member.getName(), Type.getDescriptor(this.returnType));
            } else {
                ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cls)).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
                ASMAccessorOptimizer.debug(new StringBuffer("GETFIELD ").append(property).append(":").append(Type.getDescriptor(((Field)member).getType())).toString());
                this.mv.visitFieldInsn(180, Type.getInternalName(cls), property, Type.getDescriptor(((Field)member).getType()));
            }
            this.returnType = ((Field)member).getType();
            return o;
        }
        if (member != null) {
            Object o;
            if (this.first) {
                ASMAccessorOptimizer.debug("ALOAD 2");
                this.mv.visitVarInsn(25, 2);
            }
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(member.getDeclaringClass())).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(member.getDeclaringClass()));
                this.returnType = ((Method)member).getReturnType();
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKEVIRTUAL ").append(member.getName()).append(":").append(this.returnType).toString());
                this.mv.visitMethodInsn(182, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(iFaceMeth.getDeclaringClass())).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(iFaceMeth.getDeclaringClass()));
                this.returnType = iFaceMeth.getReturnType();
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKEINTERFACE ").append(member.getName()).append(":").append(this.returnType).toString());
                this.mv.visitMethodInsn(185, Type.getInternalName(iFaceMeth.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            ASMAccessorOptimizer.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            ASMAccessorOptimizer.debug(new StringBuffer("LDC: \"").append(property).append("\"").toString());
            this.mv.visitLdcInsn(property);
            ASMAccessorOptimizer.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            ASMAccessorOptimizer.debug("ALOAD 2");
            this.mv.visitVarInsn(25, 2);
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            Object lit = LITERALS.get(property);
            if (lit instanceof Class) {
                ASMAccessorOptimizer.debug(new StringBuffer("LDC ").append(Type.getDescriptor((Class)lit)).toString());
                this.mv.visitLdcInsn(Type.getType(Type.getDescriptor((Class)lit)));
            }
            return LITERALS.get(property);
        }
        Object ts = this.tryStaticAccess();
        if (ts != null) {
            if (ts instanceof Class) {
                ASMAccessorOptimizer.debug(new StringBuffer("LDC ").append(Type.getDescriptor((Class)ts)).toString());
                this.mv.visitLdcInsn(Type.getType(Type.getDescriptor((Class)ts)));
                return ts;
            }
            ASMAccessorOptimizer.debug(new StringBuffer("GETSTATIC ").append(Type.getDescriptor(((Field)ts).getDeclaringClass())).append(".").append(((Field)ts).getName()).append("::").append(Type.getDescriptor(((Field)ts).getType())).toString());
            this.returnType = ((Field)ts).getType();
            this.mv.visitFieldInsn(178, Type.getDescriptor(((Field)ts).getDeclaringClass()), ((Field)ts).getName(), Type.getDescriptor(this.returnType));
            return ((Field)ts).get(null);
        }
        throw new PropertyAccessException(new StringBuffer("could not access property (").append(property).append(")").toString());
    }

    private Object getCollectionProperty(Object ctx, String prop) throws IllegalAccessException, InvocationTargetException {
        int index;
        String item;
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        ASMAccessorOptimizer.debug(new StringBuffer("{collections: ").append(prop).append("} ctx=").append(ctx).toString());
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (this.expr[this.cursor] == '\'' || this.expr[this.cursor] == '\"') {
            ++start;
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            int end = this.containsStringLiteralTermination();
            if (end == -1) {
                throw new PropertyAccessException("unterminated string literal in collections accessor");
            }
            item = new String(this.expr, start, end - start);
        } else {
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            item = new String(this.expr, start, this.cursor - start);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            ASMAccessorOptimizer.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            ASMAccessorOptimizer.debug(new StringBuffer("LDC: \"").append(item).append("\"").toString());
            this.mv.visitLdcInsn(item);
            ASMAccessorOptimizer.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            index = Integer.parseInt(item);
            ASMAccessorOptimizer.debug("CHECKCAST java/util/List");
            this.mv.visitTypeInsn(192, "java/util/List");
            this.intPush(index);
            ASMAccessorOptimizer.debug("INVOKEINTERFACE: java/util/List.get");
            this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            return ((List)ctx).get(index);
        }
        if (ctx instanceof Collection) {
            int count = Integer.parseInt(item);
            if (count > ((Collection)ctx).size()) {
                throw new PropertyAccessException(new StringBuffer("index [").append(count).append("] out of bounds on collections").toString());
            }
            Iterator iter = ((Collection)ctx).iterator();
            int i = 0;
            while (i < count) {
                iter.next();
                ++i;
            }
            return iter.next();
        }
        if (ctx instanceof Object[]) {
            index = Integer.parseInt(item);
            ASMAccessorOptimizer.debug("CHECKCAST [Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            this.intPush(index);
            this.mv.visitInsn(50);
            return ((Object[])ctx)[index];
        }
        if (ctx instanceof CharSequence) {
            index = Integer.parseInt(item);
            this.intPush(index);
            this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
            return new Character(((CharSequence)ctx).charAt(index));
        }
        throw new PropertyAccessException(new StringBuffer("illegal use of []: unknown type: ").append(ctx == null ? null : ctx.getClass().getName()).toString());
    }

    /*
     * Unable to fully structure code
     */
    private Object getMethod(Object ctx, String name) throws IllegalAccessException, InvocationTargetException {
        block41: {
            block40: {
                ASMAccessorOptimizer.debug(new StringBuffer("{method: ").append(name).append("}").toString());
                st = this.cursor;
                depth = 1;
                while (this.cursor++ < this.length - 1 && depth != 0) {
                    switch (this.expr[this.cursor]) {
                        case '(': {
                            ++depth;
                            break;
                        }
                        case ')': {
                            --depth;
                        }
                    }
                }
                --this.cursor;
                tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
                ++this.cursor;
                if (tk.length() == 0) {
                    args = new Object[]{};
                    preConvArgs = new Object[]{};
                    es = null;
                } else {
                    subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
                    es = new ExecutableStatement[subtokens.length];
                    args = new Object[subtokens.length];
                    preConvArgs = new Object[es.length];
                    i = 0;
                    while (i < subtokens.length) {
                        es[i] = (ExecutableStatement)MVEL.compileExpression(subtokens[i]);
                        preConvArgs[i] = args[i] = es[i].getValue(this.ctx, this.variableFactory);
                        ++i;
                    }
                }
                if (es != null) {
                    var12_12 = es;
                    i = 0;
                    var11_15 = var12_12.length;
                    while (i < var11_15) {
                        e = var12_12[i];
                        this.compiledInputs.add(e);
                        ++i;
                    }
                }
                cls = ctx instanceof Class != false ? (Class<?>)ctx : ctx.getClass();
                parameterTypes = null;
                m = ParseTools.getBestCanadidate(args, name, cls.getMethods());
                if (m != null) {
                    parameterTypes = m.getParameterTypes();
                }
                if (m == null && (m = ParseTools.getBestCanadidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
                    parameterTypes = m.getParameterTypes();
                }
                if (m == null) {
                    errorBuild = new StringAppender();
                    i = 0;
                    while (i < args.length) {
                        errorBuild.append(parameterTypes[i] != null ? parameterTypes[i].getClass().getName() : null);
                        if (i < args.length - 1) {
                            errorBuild.append(", ");
                        }
                        ++i;
                    }
                    throw new PropertyAccessException(new StringBuffer("unable to resolve method: ").append(cls.getName()).append(".").append(name).append("(").append(errorBuild.toString()).append(") [arglength=").append(args.length).append("]").toString());
                }
                if (es != null) {
                    i = 0;
                    while (i < es.length) {
                        cExpr = es[i];
                        if (cExpr.getKnownIngressType() == null) {
                            cExpr.setKnownIngressType(parameterTypes[i]);
                            cExpr.computeTypeConversionRule();
                        }
                        if (!cExpr.isConvertableIngressEgress()) {
                            args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < args.length) {
                        args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                        ++i;
                    }
                }
                if (this.first) {
                    ASMAccessorOptimizer.debug("ALOAD 1");
                    this.mv.visitVarInsn(25, 1);
                }
                if (m.getParameterTypes().length != 0) break block40;
                if ((m.getModifiers() & 8) != 0) {
                    ASMAccessorOptimizer.debug(new StringBuffer("INVOKESTATIC ").append(m.getName()).toString());
                    this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                } else {
                    ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(m.getDeclaringClass())).toString());
                    this.mv.visitTypeInsn(192, Type.getInternalName(m.getDeclaringClass()));
                    ASMAccessorOptimizer.debug(new StringBuffer("INVOKEVIRTUAL ").append(m.getName()).toString());
                    this.mv.visitMethodInsn(182, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                }
                this.returnType = m.getReturnType();
                ++this.stacksize;
                break block41;
            }
            if ((m.getModifiers() & 8) == 0) {
                ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cls)).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
            }
            i = 0;
            while (i < es.length) {
                block43: {
                    block42: {
                        ASMAccessorOptimizer.debug("ALOAD 0");
                        this.mv.visitVarInsn(25, 0);
                        ASMAccessorOptimizer.debug(new StringBuffer("GETFIELD p").append(this.inputs++).toString());
                        this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(this.inputs - 1).toString(), "Lorg/mvel/ExecutableStatement;");
                        ASMAccessorOptimizer.debug("ALOAD 2");
                        this.mv.visitVarInsn(25, 2);
                        ASMAccessorOptimizer.debug("ALOAD 3");
                        this.mv.visitVarInsn(25, 3);
                        ASMAccessorOptimizer.debug("INVOKEINTERFACE ExecutableStatement.getValue");
                        try {
                            v0 = Class.forName("org.mvel.ExecutableStatement");
                        }
                        catch (ClassNotFoundException v1) {
                            throw new NoClassDefFoundError(v1.getMessage());
                        }
                        this.mv.visitMethodInsn(185, Type.getInternalName(v0), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                        if (!parameterTypes[i].isPrimitive()) break block42;
                        this.unwrapPrimitive(parameterTypes[i]);
                        break block43;
                    }
                    if (preConvArgs[i] == null) ** GOTO lbl-1000
                    try {
                        v2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                    if (parameterTypes[i] != v2 && !parameterTypes[i].isAssignableFrom(preConvArgs[i].getClass())) lbl-1000:
                    // 2 sources

                    {
                        ASMAccessorOptimizer.debug(new StringBuffer("LDC ").append(Type.getType(parameterTypes[i])).toString());
                        this.mv.visitLdcInsn(Type.getType(parameterTypes[i]));
                        ASMAccessorOptimizer.debug("INVOKESTATIC DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(parameterTypes[i])).toString());
                        this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                    } else {
                        try {
                            v4 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException v5) {
                            throw new NoClassDefFoundError(v5.getMessage());
                        }
                        if (parameterTypes[i] == v4) {
                            ASMAccessorOptimizer.debug("<<<DYNAMIC TYPE OPTIMIZATION STRING>>");
                            this.mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
                        } else {
                            ASMAccessorOptimizer.debug("<<<DYNAMIC TYPING BYPASS>>>");
                            ASMAccessorOptimizer.debug(new StringBuffer("<<<OPT. JUSTIFICATION ").append(parameterTypes[i]).append("=").append(preConvArgs[i].getClass()).append(">>>").toString());
                            ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(parameterTypes[i])).toString());
                            this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                        }
                    }
                }
                ++i;
            }
            if ((m.getModifiers() & 8) != 0) {
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKESTATIC: ").append(m.getName()).toString());
                this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else if (m.getDeclaringClass() != cls && m.getDeclaringClass().isInterface()) {
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKEINTERFACE: ").append(Type.getInternalName(m.getDeclaringClass())).append(".").append(m.getName()).toString());
                this.mv.visitMethodInsn(185, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else {
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKEVIRTUAL: ").append(Type.getInternalName(cls)).append(".").append(m.getName()).toString());
                this.mv.visitMethodInsn(182, Type.getInternalName(cls), m.getName(), Type.getMethodDescriptor(m));
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        }
        return m.invoke(ctx, args);
    }

    private static Class loadClass(String className, byte[] b) throws IllegalAccessException, InvocationTargetException {
        defineClass.setAccessible(true);
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.mvel.optimizers.impl.asm.ASMAccessorOptimizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class clazz2 = (Class)defineClass.invoke((Object)clazz.getClassLoader(), className, b, new Integer(0), new Integer(b.length));
            return clazz2;
        }
        finally {
            defineClass.setAccessible(false);
        }
    }

    private static void debug(String instruction) {
        if (!$assertionsDisabled && !ParseTools.debug(instruction)) {
            throw new AssertionError();
        }
    }

    public String getName() {
        return "ASM";
    }

    @Override
    public Object getResultOptPass() {
        return this.val;
    }

    private Class getWrapperClass(Class cls) {
        if (cls == Boolean.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Integer.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Float.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Double.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Short.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Long.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Byte.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Character.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return null;
    }

    private void unwrapPrimitive(Class cls) {
        if (cls == Boolean.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Boolean");
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Boolean.booleanValue");
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (cls == Integer.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Integer");
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Integer.intValue");
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (cls == Float.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Float");
            this.mv.visitTypeInsn(192, "java/lang/Float");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Float.floatValue");
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (cls == Double.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Double");
            this.mv.visitTypeInsn(192, "java/lang/Double");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Double.doubleValue");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else if (cls == Short.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Short");
            this.mv.visitTypeInsn(192, "java/lang/Short");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Short.shortValue");
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (cls == Long.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Long");
            this.mv.visitTypeInsn(192, "java/lang/Long");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Long.longValue");
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (cls == Byte.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Byte");
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Byte.byteValue");
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (cls == Character.TYPE) {
            ASMAccessorOptimizer.debug("CHECKCAST java/lang/Character");
            this.mv.visitTypeInsn(192, "java/lang/Character");
            ASMAccessorOptimizer.debug("INVOKEVIRTUAL java/lang/Character.charValue");
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        }
    }

    private void wrapPrimitive(Class<? extends Object> cls) {
        if (cls == Boolean.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (cls == Integer.TYPE) {
            ASMAccessorOptimizer.debug("INVOKESTATIC java/lang/Integer.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (cls == Float.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (cls == Double.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (cls == Short.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (cls == Long.TYPE) {
            ASMAccessorOptimizer.debug("INVOKESTATIC java/lang/Long.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (cls == Byte.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (cls == Character.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        }
    }

    private void buildInputs() {
        if (this.inputs == 0) {
            return;
        }
        ASMAccessorOptimizer.debug("\n{SETTING UP MEMBERS...}\n");
        StringAppender constSig = new StringAppender("(");
        int size = this.inputs;
        int i = 0;
        while (i < size) {
            ASMAccessorOptimizer.debug(new StringBuffer("ACC_PRIVATE p").append(i).toString());
            FieldVisitor fv = this.cw.visitField(2, new StringBuffer("p").append(i).toString(), "Lorg/mvel/ExecutableStatement;", null, null);
            fv.visitEnd();
            constSig.append("Lorg/mvel/ExecutableStatement;");
            ++i;
        }
        constSig.append(")V");
        ASMAccessorOptimizer.debug("\n{CREATING INJECTION CONSTRUCTOR}\n");
        MethodVisitor cv = this.cw.visitMethod(1, "<init>", constSig.toString(), null, null);
        cv.visitCode();
        ASMAccessorOptimizer.debug("ALOAD 0");
        cv.visitVarInsn(25, 0);
        ASMAccessorOptimizer.debug("INVOKESPECIAL java/lang/Object.<init>");
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        int i2 = 0;
        while (i2 < size) {
            ASMAccessorOptimizer.debug("ALOAD 0");
            cv.visitVarInsn(25, 0);
            ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(i2 + 1).toString());
            cv.visitVarInsn(25, i2 + 1);
            ASMAccessorOptimizer.debug(new StringBuffer("PUTFIELD p").append(i2).toString());
            cv.visitFieldInsn(181, this.className, new StringBuffer("p").append(i2).toString(), "Lorg/mvel/ExecutableStatement;");
            ++i2;
        }
        ASMAccessorOptimizer.debug("RETURN");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv.visitEnd();
        ASMAccessorOptimizer.debug("}");
    }

    private int _getAccessor(Object o, int type, int register, int index) {
        Class<?> clazz;
        if (o instanceof List) {
            ASMAccessorOptimizer.debug("NEW org/mvel/util/FastList");
            this.mv.visitTypeInsn(187, LIST_IMPL);
            ASMAccessorOptimizer.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((List)o).size());
            ASMAccessorOptimizer.debug("INVOKESPECIAL org/mvel/util/FastList.<init>");
            this.mv.visitMethodInsn(183, LIST_IMPL, "<init>", "(I)V");
            ASMAccessorOptimizer.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : (List)o) {
                if (this._getAccessor(item, 1, c, 0) != 3) {
                    ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(c).toString());
                    this.mv.visitVarInsn(25, c);
                    ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(this.lastCnum).toString());
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                ASMAccessorOptimizer.debug("INVOKEINTERFACE java/util/List.add");
                this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                ASMAccessorOptimizer.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 1;
        }
        if (o instanceof Map) {
            ASMAccessorOptimizer.debug("NEW java/util/HashMap");
            this.mv.visitTypeInsn(187, MAP_IMPL);
            ASMAccessorOptimizer.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((Map)o).size());
            ASMAccessorOptimizer.debug("INVOKESPECIAL java/util/HashMap.<init>");
            this.mv.visitMethodInsn(183, MAP_IMPL, "<init>", "(I)V");
            ASMAccessorOptimizer.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : ((Map)o).keySet()) {
                this._getAccessor(item, 2, c, 0);
                int firstParm = this.lastCnum;
                this._getAccessor(((Map)o).get(item), 2, c, 0);
                ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(c).toString());
                this.mv.visitVarInsn(25, c);
                ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(firstParm).append(" (").append(((Map)o).get(item)).append(")").toString());
                this.mv.visitVarInsn(25, firstParm);
                ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(this.lastCnum).append(" (").append(item).append(")").toString());
                this.mv.visitVarInsn(25, this.lastCnum);
                ASMAccessorOptimizer.debug("INVOKEINTERFACE java/util/Map.put");
                this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                ASMAccessorOptimizer.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 2;
        }
        if (o instanceof Object[]) {
            this.intPush(((Object[])o).length);
            ASMAccessorOptimizer.debug(new StringBuffer("ANEWARRAY (").append(o.hashCode()).append(")").toString());
            this.mv.visitTypeInsn(189, "java/lang/Object");
            ASMAccessorOptimizer.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            int i = 0;
            Object[] objectArray = (Object[])o;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object item = objectArray[n];
                if (this._getAccessor(item, 0, c, i) != 3) {
                    ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(c).toString());
                    this.mv.visitVarInsn(25, c);
                    this.intPush(i);
                    ASMAccessorOptimizer.debug(new StringBuffer("ALOAD + ").append(this.lastCnum).toString());
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                ASMAccessorOptimizer.debug(new StringBuffer("AASTORE (").append(o.hashCode()).append(")").toString());
                this.mv.visitInsn(83);
                ++i;
                ++n;
            }
            this.lastCnum = c;
            return 0;
        }
        this.compiledInputs.add((ExecutableStatement)MVEL.compileExpression((String)o));
        switch (type) {
            case 0: {
                ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(register).toString());
                this.mv.visitVarInsn(25, register);
                this.intPush(index);
                break;
            }
            case 1: {
                ASMAccessorOptimizer.debug(new StringBuffer("ALOAD ").append(register).toString());
                this.mv.visitVarInsn(25, register);
            }
        }
        ASMAccessorOptimizer.debug("ALOAD 0");
        this.mv.visitVarInsn(25, 0);
        ASMAccessorOptimizer.debug(new StringBuffer("GETFIELD p").append(this.inputs++).toString());
        this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(this.inputs - 1).toString(), "Lorg/mvel/ExecutableStatement;");
        ASMAccessorOptimizer.debug("ALOAD 2");
        this.mv.visitVarInsn(25, 2);
        ASMAccessorOptimizer.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        ASMAccessorOptimizer.debug("INVOKEINTERFACE ExecutableStatement.getValue");
        try {
            clazz = Class.forName("org.mvel.ExecutableStatement");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mv.visitMethodInsn(185, Type.getInternalName(clazz), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
        switch (type) {
            case 2: {
                ASMAccessorOptimizer.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).append("(").append(o).append(")").toString());
                this.lastCnum = ++this.cnum;
                this.mv.visitVarInsn(58, this.cnum);
            }
        }
        return 3;
    }

    @Override
    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.cursor = 0;
        this.expr = property;
        this.length = property.length;
        this.compiledInputs = new ArrayList();
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        CollectionParser parser = new CollectionParser();
        Object o = ((List)parser.parseCollection(property)).get(0);
        this._initJIT();
        this._getAccessor(o, 1, 0, 0);
        ASMAccessorOptimizer.debug("ALOAD 4");
        this.mv.visitVarInsn(25, 4);
        this._finishJIT();
        int end = parser.getEnd() + 2;
        try {
            Accessor compiledAccessor = this._initializeAccessor();
            if (end < property.length) {
                return new Union(compiledAccessor, ParseTools.subset(property, end));
            }
            return compiledAccessor;
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize collection", e);
        }
    }

    private void intPush(int index) {
        if (index < 6) {
            switch (index) {
                case 0: {
                    ASMAccessorOptimizer.debug("ICONST_0");
                    this.mv.visitInsn(3);
                    break;
                }
                case 1: {
                    ASMAccessorOptimizer.debug("ICONST_1");
                    this.mv.visitInsn(4);
                    break;
                }
                case 2: {
                    ASMAccessorOptimizer.debug("ICONST_2");
                    this.mv.visitInsn(5);
                    break;
                }
                case 3: {
                    ASMAccessorOptimizer.debug("ICONST_3");
                    this.mv.visitInsn(6);
                    break;
                }
                case 4: {
                    ASMAccessorOptimizer.debug("ICONST_4");
                    this.mv.visitInsn(7);
                    break;
                }
                case 5: {
                    ASMAccessorOptimizer.debug("ICONST_5");
                    this.mv.visitInsn(8);
                }
            }
        } else {
            ASMAccessorOptimizer.debug(new StringBuffer("BIPUSH ").append(index).toString());
            this.mv.visitIntInsn(16, index);
        }
    }

    @Override
    public Accessor optimizeAssignment(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        Class<?> clazz;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.compiledInputs = new ArrayList();
        this._initJIT();
        this.greedy = false;
        String varName = this.nextToken().getName();
        if (!this.nextToken().isOperator(new Integer(30))) {
            throw new OptimizationFailure("expected assignment operator");
        }
        Token valTk = this.captureTokenToEOS();
        ExecutableStatement value = valTk.isLiteral() ? new ExecutableLiteral(valTk.getLiteralValue()) : (valTk.isNewObject() ? new ExecutableAccessor(valTk, false) : (ExecutableStatement)MVEL.compileExpression(valTk.getNameAsArray()));
        ++this.inputs;
        this.compiledInputs.add(value);
        ASMAccessorOptimizer.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        ASMAccessorOptimizer.debug("INVOKESTATIC org/mvel/util/ParseTools.findLocalVariableFactory");
        this.mv.visitMethodInsn(184, "org/mvel/util/ParseTools", "finalLocalVariableFactory", "(Lorg/mvel/integration/VariableResolverFactory;)Lorg/mvel/integration/VariableResolverFactory;");
        ASMAccessorOptimizer.debug(new StringBuffer("LDC '").append(varName).append("'").toString());
        this.mv.visitLdcInsn(varName);
        ASMAccessorOptimizer.debug("ALOAD 0: this");
        this.mv.visitVarInsn(25, 0);
        ASMAccessorOptimizer.debug("GETFIELD p0");
        this.mv.visitFieldInsn(180, this.className, "p0", "Lorg/mvel/ExecutableStatement;");
        ASMAccessorOptimizer.debug("ALOAD 2");
        this.mv.visitVarInsn(25, 2);
        ASMAccessorOptimizer.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        ASMAccessorOptimizer.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
        this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
        ASMAccessorOptimizer.debug("DUP");
        this.mv.visitInsn(89);
        ASMAccessorOptimizer.debug("ASTORE 4");
        this.mv.visitVarInsn(58, 4);
        ASMAccessorOptimizer.debug("INVOKEINTERFACE org/mvel/integration/VariableResolverFactory.createVariable");
        this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolverFactory", "createVariable", "(Ljava/lang/String;Ljava/lang/Object;)Lorg/mvel/integration/VariableResolver;");
        ASMAccessorOptimizer.debug("POP");
        this.mv.visitInsn(87);
        ASMAccessorOptimizer.debug("ALOAD 4");
        this.mv.visitVarInsn(25, 4);
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.returnType = clazz;
        try {
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not create assignment", e);
        }
    }

    @Override
    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this._initJIT();
        this.compiledInputs = new ArrayList();
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        String[] cnsRes = ParseTools.captureContructorAndResidual(property);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        try {
            if (constructorParms != null) {
                String[] stringArray = constructorParms;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String constructorParm = stringArray[n];
                    this.compiledInputs.add((ExecutableStatement)MVEL.compileExpression(constructorParm));
                    ++n;
                }
                String s = new String(ParseTools.subset(property, 0, ArrayTools.findFirst('(', property)));
                Class cls = LITERALS.containsKey(s) ? (Class)LITERALS.get(s) : ParseTools.createClass(s);
                ASMAccessorOptimizer.debug(new StringBuffer("NEW ").append(Type.getDescriptor(cls)).toString());
                this.mv.visitTypeInsn(187, Type.getDescriptor(cls));
                ASMAccessorOptimizer.debug("DUP");
                this.mv.visitInsn(89);
                this.inputs = constructorParms.length;
                Object[] parms = new Object[constructorParms.length];
                int i = 0;
                for (ExecutableStatement es : this.compiledInputs) {
                    parms[i++] = es.getValue(ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
                if (cns == null) {
                    throw new CompileException(new StringBuffer("unable to find constructor for: ").append(cls.getName()).toString());
                }
                i = 0;
                while (i < constructorParms.length) {
                    Class tg;
                    ASMAccessorOptimizer.debug("ALOAD 0");
                    this.mv.visitVarInsn(25, 0);
                    ASMAccessorOptimizer.debug(new StringBuffer("GETFIELD p").append(i).toString());
                    this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(i).toString(), "Lorg/mvel/ExecutableStatement;");
                    ASMAccessorOptimizer.debug("ALOAD 2");
                    this.mv.visitVarInsn(25, 2);
                    ASMAccessorOptimizer.debug("ALOAD 3");
                    this.mv.visitVarInsn(25, 3);
                    ASMAccessorOptimizer.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
                    this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                    Class clazz = tg = cns.getParameterTypes()[i].isPrimitive() ? this.getWrapperClass(cns.getParameterTypes()[i]) : cns.getParameterTypes()[i];
                    if (!parms[i].getClass().isAssignableFrom(cns.getParameterTypes()[i])) {
                        ASMAccessorOptimizer.debug(new StringBuffer("LDC ").append(Type.getType(tg)).toString());
                        this.mv.visitLdcInsn(Type.getType(tg));
                        ASMAccessorOptimizer.debug("INVOKESTATIC org/mvel/DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        if (cns.getParameterTypes()[i].isPrimitive()) {
                            this.unwrapPrimitive(cns.getParameterTypes()[i]);
                        } else {
                            ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(tg)).toString());
                            this.mv.visitTypeInsn(192, Type.getInternalName(tg));
                        }
                    } else {
                        ASMAccessorOptimizer.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cns.getParameterTypes()[i])).toString());
                        this.mv.visitTypeInsn(192, Type.getInternalName(cns.getParameterTypes()[i]));
                    }
                    ++i;
                }
                ASMAccessorOptimizer.debug(new StringBuffer("INVOKESPECIAL ").append(Type.getDescriptor(cls)).append(".<init> : ").append(Type.getConstructorDescriptor(cns)).toString());
                this.mv.visitMethodInsn(183, Type.getDescriptor(cls), "<init>", Type.getConstructorDescriptor(cns));
                this._finishJIT();
                Accessor acc = this._initializeAccessor();
                if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                    return new Union(acc, cnsRes[1].toCharArray());
                }
                return acc;
            }
            Class<?> cls = Class.forName(new String(property));
            ASMAccessorOptimizer.debug(new StringBuffer("NEW ").append(Type.getDescriptor(cls)).toString());
            this.mv.visitTypeInsn(187, Type.getDescriptor(cls));
            ASMAccessorOptimizer.debug("DUP");
            this.mv.visitInsn(89);
            Constructor<?> cns = cls.getConstructor(new Class[0]);
            ASMAccessorOptimizer.debug("INVOKESPECIAL <init>");
            this.mv.visitMethodInsn(183, Type.getDescriptor(cls), "<init>", Type.getConstructorDescriptor(cns));
            this._finishJIT();
            Accessor acc = this._initializeAccessor();
            if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                return new Union(acc, cnsRes[1].toCharArray());
            }
            return acc;
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize construtor", e);
        }
    }

    @Override
    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        throw new OptimizationNotSupported("JIT does not yet support fold operations.");
    }

    @Override
    public Accessor optimizeReturn(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        throw new OptimizationNotSupported("JIT does not yet support return");
    }
}

