/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.Accessor;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.PropertyAccessException;
import org.mvel.Token;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.impl.refl.ArrayAccessor;
import org.mvel.optimizers.impl.refl.Assignment;
import org.mvel.optimizers.impl.refl.ConstructorAccessor;
import org.mvel.optimizers.impl.refl.FieldAccessor;
import org.mvel.optimizers.impl.refl.Fold;
import org.mvel.optimizers.impl.refl.GetterAccessor;
import org.mvel.optimizers.impl.refl.IndexedCharSeqAccessor;
import org.mvel.optimizers.impl.refl.ListAccessor;
import org.mvel.optimizers.impl.refl.Literal;
import org.mvel.optimizers.impl.refl.MapAccessor;
import org.mvel.optimizers.impl.refl.MethodAccessor;
import org.mvel.optimizers.impl.refl.Return;
import org.mvel.optimizers.impl.refl.StaticReferenceAccessor;
import org.mvel.optimizers.impl.refl.StaticVarAccessor;
import org.mvel.optimizers.impl.refl.ThisValueAccessor;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.optimizers.impl.refl.VariableAccessor;
import org.mvel.optimizers.impl.refl.collection.ArrayCreator;
import org.mvel.optimizers.impl.refl.collection.ExprValueAccessor;
import org.mvel.optimizers.impl.refl.collection.ListCreator;
import org.mvel.optimizers.impl.refl.collection.MapCreator;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class ReflectiveAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorNode rootNode;
    private AccessorNode currNode;
    private Object ctx;
    private Object thisRef;
    private Object val;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final Object[] EMPTYARG;
    private boolean first = true;
    private static final Map<String, Accessor> REFLECTIVE_ACCESSOR_CACHE;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTYARG = new Object[0];
        REFLECTIVE_ACCESSOR_CACHE = new WeakHashMap<String, Accessor>();
    }

    public ReflectiveAccessorOptimizer() {
    }

    private ReflectiveAccessorOptimizer(char[] property, Object ctx, Object thisRef, VariableResolverFactory variableFactory) {
        this.expr = property;
        this.length = property != null ? property.length : 0;
        this.ctx = ctx;
        this.variableFactory = variableFactory;
        this.thisRef = thisRef;
    }

    public static Object get(String expression, Object ctx) {
        if (REFLECTIVE_ACCESSOR_CACHE.containsKey(expression)) {
            return REFLECTIVE_ACCESSOR_CACHE.get(expression).getValue(ctx, null, null);
        }
        Accessor accessor = new ReflectiveAccessorOptimizer().optimize(expression.toCharArray(), ctx, null, null, false);
        REFLECTIVE_ACCESSOR_CACHE.put(expression, accessor);
        return accessor.getValue(ctx, null, null);
    }

    public Accessor optimize(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.currNode = null;
        this.rootNode = null;
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        return this.compileGetChain();
    }

    private Accessor compileGetChain() {
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                        break;
                    }
                }
                this.first = false;
            }
            this.val = curr;
            return this.rootNode;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException("array or collections index out of bounds (property: " + new String(this.expr) + ")", e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException("failed to access property: <<" + new String(this.expr) + ">> in: " + (this.ctx != null ? this.ctx.getClass() : null), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer exception in property: " + new String(this.expr), e);
        }
        catch (Exception e) {
            throw new PropertyAccessException("unknown exception in expression: " + new String(this.expr), e);
        }
    }

    private void addAccessorNode(AccessorNode an) {
        if (this.rootNode == null) {
            this.rootNode = this.currNode = an;
        } else {
            this.currNode = this.currNode.setNextNode(an);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(property)) {
            VariableAccessor accessor = new VariableAccessor(property, this.variableFactory);
            this.addAccessorNode(accessor);
            return this.variableFactory.getVariableResolver(property).getValue();
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member instanceof Field) {
            FieldAccessor accessor = new FieldAccessor();
            accessor.setField((Field)member);
            this.addAccessorNode(accessor);
            return ((Field)member).get(ctx);
        }
        if (member != null) {
            Object o;
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                GetterAccessor accessor = new GetterAccessor((Method)member);
                this.addAccessorNode(accessor);
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                GetterAccessor accessor = new GetterAccessor(iFaceMeth);
                this.addAccessorNode(accessor);
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            MapAccessor accessor = new MapAccessor();
            accessor.setProperty(property);
            this.addAccessorNode(accessor);
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            ThisValueAccessor accessor = new ThisValueAccessor();
            this.addAccessorNode(accessor);
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            StaticReferenceAccessor accessor = new StaticReferenceAccessor();
            accessor.setLiteral(LITERALS.get(property));
            this.addAccessorNode(accessor);
            return accessor.getLiteral();
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                StaticReferenceAccessor accessor = new StaticReferenceAccessor();
                accessor.setLiteral(tryStaticMethodRef);
                this.addAccessorNode(accessor);
                return tryStaticMethodRef;
            }
            StaticVarAccessor accessor = new StaticVarAccessor((Field)tryStaticMethodRef);
            this.addAccessorNode(accessor);
            return ((Field)tryStaticMethodRef).get(null);
        }
        throw new PropertyAccessException("could not access property ('" + property + "')");
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        String item;
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (this.expr[this.cursor] == '\'' || this.expr[this.cursor] == '\"') {
            ++start;
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            int end = this.containsStringLiteralTermination();
            if (end == -1) {
                throw new PropertyAccessException("unterminated string literal in collections accessor");
            }
            item = new String(this.expr, start, end - start);
        } else {
            if (!this.scanTo(']')) {
                throw new PropertyAccessException("unterminated '['");
            }
            item = new String(this.expr, start, this.cursor - start);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            MapAccessor accessor = new MapAccessor();
            accessor.setProperty(item);
            this.addAccessorNode(accessor);
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            ListAccessor accessor = new ListAccessor();
            accessor.setIndex(Integer.parseInt(item));
            this.addAccessorNode(accessor);
            return ((List)ctx).get(accessor.getIndex());
        }
        if (ctx instanceof Collection) {
            int count = Integer.parseInt(item);
            if (count > ((Collection)ctx).size()) {
                throw new PropertyAccessException("index [" + count + "] out of bounds on collections");
            }
            Iterator iter = ((Collection)ctx).iterator();
            int i = 0;
            while (i < count) {
                iter.next();
                ++i;
            }
            return iter.next();
        }
        if (ctx instanceof Object[]) {
            ArrayAccessor accessor = new ArrayAccessor();
            accessor.setIndex(Integer.parseInt(item));
            this.addAccessorNode(accessor);
            return ((Object[])ctx)[accessor.getIndex()];
        }
        if (ctx instanceof CharSequence) {
            IndexedCharSeqAccessor accessor = new IndexedCharSeqAccessor();
            accessor.setIndex(Integer.parseInt(item));
            this.addAccessorNode(accessor);
            return new Character(((CharSequence)ctx).charAt(accessor.getIndex()));
        }
        throw new PropertyAccessException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        ExecutableStatement[] es;
        Object[] args;
        int st = this.cursor;
        int depth = 1;
        while (this.cursor++ < this.length - 1 && depth != 0) {
            switch (this.expr[this.cursor]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
        }
        --this.cursor;
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            int i = 0;
            while (i < subtokens.length) {
                es[i] = (ExecutableStatement)MVEL.compileExpression(subtokens[i]);
                args[i] = es[i].getValue(this.ctx, this.variableFactory);
                ++i;
            }
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : ctx.getClass();
        Class[] parameterTypes = null;
        Method m = ParseTools.getBestCanadidate(args, name, cls.getMethods());
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCanadidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            int i = 0;
            while (i < args.length) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i < args.length - 1) {
                    errorBuild.append(", ");
                }
                ++i;
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        if (es != null) {
            int i = 0;
            while (i < es.length) {
                ExecutableStatement cExpr = es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (!cExpr.isConvertableIngressEgress()) {
                    args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < args.length) {
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                ++i;
            }
        }
        MethodAccessor access = new MethodAccessor();
        access.setMethod(m);
        access.setParms(es);
        this.addAccessorNode(access);
        return m.invoke(ctx, args);
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) throws Exception {
        return this.rootNode.getValue(ctx, elCtx, variableFactory);
    }

    public static void main(String[] args) {
        new ReflectiveAccessorOptimizer().optimizeCollection("[test, foo, bar, {1,2,3}]".toCharArray(), null, null, null);
    }

    private Accessor _getAccessor(Object o) {
        if (o instanceof List) {
            Accessor[] a = new Accessor[((List)o).size()];
            int i = 0;
            Iterator iterator = ((List)o).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                a[i++] = this._getAccessor(item);
            }
            return new ListCreator(a);
        }
        if (o instanceof Map) {
            Accessor[] k = new Accessor[((Map)o).size()];
            Accessor[] v = new Accessor[k.length];
            int i = 0;
            Iterator iterator = ((Map)o).keySet().iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                k[i] = this._getAccessor(item);
                v[i++] = this._getAccessor(((Map)o).get(item));
            }
            return new MapCreator(k, v);
        }
        if (o instanceof Object[]) {
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            Object[] objectArray = (Object[])o;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object item = objectArray[n];
                a[i++] = this._getAccessor(item);
                ++n;
            }
            return new ArrayCreator(a);
        }
        return new ExprValueAccessor((String)o);
    }

    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        CollectionParser parser = new CollectionParser();
        Object o = ((List)parser.parseCollection(property)).get(0);
        Accessor root = this._getAccessor(o);
        int end = parser.getEnd() + 2;
        if (end < property.length) {
            return new Union(root, ParseTools.subset(property, end));
        }
        return root;
    }

    public Accessor optimizeAssignment(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        this.greedy = false;
        Token var = this.nextToken();
        if (!this.nextToken().isOperator(new Integer(30))) {
            throw new CompileException("expected assignment operator");
        }
        Token expr = this.captureTokenToEOS();
        if (expr.isLiteral()) {
            if (!$assertionsDisabled && !ParseTools.debug("ASSIGN_LITERAL '" + expr.getName() + "'")) {
                throw new AssertionError();
            }
            Literal lit = new Literal(expr.getReducedValueAccelerated(ctx, thisRef, factory));
            this.val = lit.getValue(ctx, thisRef, factory);
            return new Assignment(var.getName(), lit);
        }
        if (expr.isNewObject()) {
            return new Assignment(var.getName(), this.optimizeObjectCreation(expr.getNameAsArray(), ctx, thisRef, factory));
        }
        if (!$assertionsDisabled && !ParseTools.debug("ASSIGN_EXPR '" + expr.getName() + "'")) {
            throw new AssertionError();
        }
        ExprValueAccessor valAcc = new ExprValueAccessor(expr.getName());
        this.val = valAcc.getValue(ctx, thisRef, factory);
        return new Assignment(var.getName(), valAcc);
    }

    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        try {
            AccessorNode contructor = ReflectiveAccessorOptimizer.compileConstructor(property, ctx, factory);
            this.val = contructor.getValue(property, thisRef, factory);
            return contructor;
        }
        catch (Exception e) {
            throw new CompileException("could not create constructor", e);
        }
    }

    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        this.greedy = false;
        if (this.expr[this.cursor] == '(') {
            this.balancedCapture('(');
            this.length = this.cursor;
            this.cursor = 1;
        }
        Token var = this.nextToken();
        if (!this.nextToken().isOperator(new Integer(34))) {
            throw new CompileException("expected fold operator");
        }
        this.greedy = true;
        Fold fold = new Fold(var.getNameAsArray(), new ExprValueAccessor(this.nextToken().getName()));
        if (this.length < property.length - 1) {
            this.cursor += 2;
            Union union = new Union(fold, ParseTools.subset(property, this.cursor));
            this.val = union.getValue(ctx, thisRef, factory);
            return union;
        }
        this.val = fold.getValue(ctx, thisRef, factory);
        return fold;
    }

    private void setRootNode(AccessorNode rootNode) {
        this.rootNode = this.currNode = rootNode;
    }

    private AccessorNode getRootNode() {
        return this.rootNode;
    }

    public Object getResultOptPass() {
        return this.val;
    }

    public static AccessorNode compileConstructor(char[] expression, Object ctx, VariableResolverFactory vars) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        String[] cnsRes = ParseTools.captureContructorAndResidual(expression);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        if (constructorParms != null) {
            String s = new String(ParseTools.subset(expression, 0, ArrayTools.findFirst('(', expression)));
            Class cls = LITERALS.containsKey(s) ? (Class)LITERALS.get(s) : ParseTools.createClass(s);
            ExecutableStatement[] cStmts = new ExecutableStatement[constructorParms.length];
            int i = 0;
            while (i < constructorParms.length) {
                cStmts[i] = (ExecutableStatement)MVEL.compileExpression(constructorParms[i]);
                ++i;
            }
            Object[] parms = new Object[constructorParms.length];
            int i2 = 0;
            while (i2 < constructorParms.length) {
                parms[i2] = cStmts[i2].getValue(ctx, vars);
                ++i2;
            }
            Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
            if (cns == null) {
                throw new CompileException("unable to find constructor for: " + cls.getName());
            }
            int i3 = 0;
            while (i3 < parms.length) {
                parms[i3] = DataConversion.convert(parms[i3], cns.getParameterTypes()[i3]);
                ++i3;
            }
            AccessorNode ca = new ConstructorAccessor(cns, cStmts);
            if (cnsRes.length > 1) {
                ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(parms), ctx, vars);
                compiledOptimizer.setRootNode(ca);
                compiledOptimizer.compileGetChain();
                ca = compiledOptimizer.getRootNode();
            }
            return ca;
        }
        Constructor<?> cns = Class.forName(new String(expression)).getConstructor(new Class[0]);
        AccessorNode ca = new ConstructorAccessor(cns, null);
        if (cnsRes.length > 1) {
            ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(new Object[0]), ctx, vars);
            compiledOptimizer.setRootNode(ca);
            compiledOptimizer.compileGetChain();
            ca = compiledOptimizer.getRootNode();
        }
        return ca;
    }

    public Accessor optimizeReturn(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression(property);
        Return ret = new Return(stmt);
        this.val = stmt.getValue(ctx, thisRef, factory);
        return ret;
    }
}

