/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.async.Duration;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.FinalExpiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.annotations.async.IntervalDuration;
import org.jboss.seam.async.CronSchedule;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.async.TransactionCompletionEvent;
import org.jboss.seam.async.TransactionSuccessEvent;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher<T, S>
implements Dispatcher<T, S> {
    public static final String EXECUTING_ASYNCHRONOUS_CALL = "org.jboss.seam.core.executingAsynchronousCall";

    public static Dispatcher instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("no application context active");
        }
        return (Dispatcher)Component.getInstance("org.jboss.seam.async.dispatcher");
    }

    @Override
    public void scheduleTransactionSuccessEvent(String type, Object ... parameters) {
        Transaction.instance().registerSynchronization(new TransactionSuccessEvent(type, parameters));
    }

    @Override
    public void scheduleTransactionCompletionEvent(String type, Object ... parameters) {
        Transaction.instance().registerSynchronization(new TransactionCompletionEvent(type, parameters));
    }

    protected Schedule createSchedule(InvocationContext invocation) {
        Long duration = null;
        Date expiration = null;
        Date finalExpiration = null;
        Long intervalDuration = null;
        String cron = null;
        Annotation[][] parameterAnnotations = invocation.getMethod().getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                if (annotation.annotationType().equals(Duration.class)) {
                    duration = (Long)invocation.getParameters()[i];
                    continue;
                }
                if (annotation.annotationType().equals(IntervalDuration.class)) {
                    intervalDuration = (Long)invocation.getParameters()[i];
                    continue;
                }
                if (annotation.annotationType().equals(Expiration.class)) {
                    expiration = (Date)invocation.getParameters()[i];
                    continue;
                }
                if (annotation.annotationType().equals(FinalExpiration.class)) {
                    finalExpiration = (Date)invocation.getParameters()[i];
                    continue;
                }
                if (!annotation.annotationType().equals(IntervalCron.class)) continue;
                cron = (String)invocation.getParameters()[i];
            }
        }
        if (cron != null) {
            return new CronSchedule(duration, expiration, cron, finalExpiration);
        }
        return new TimerSchedule(duration, expiration, intervalDuration, finalExpiration);
    }
}

