/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.rmi.server.UID;
import java.util.Date;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousEvent;
import org.jboss.seam.async.AsynchronousInvocation;
import org.jboss.seam.async.CronSchedule;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.async.dispatcher")
@Install(value=false, precedence=0)
@BypassInterceptors
public class QuartzDispatcher
extends AbstractDispatcher<QuartzTriggerHandle, Schedule> {
    private static final LogProvider log = Logging.getLogProvider(QuartzDispatcher.class);
    private Scheduler scheduler;

    @Create
    public void initScheduler() {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            this.scheduler = schedulerFactory.getScheduler();
            this.scheduler.start();
            log.info("The QuartzDispatcher has started");
        }
        catch (SchedulerException se) {
            log.error("Cannot get or start a Quartz Scheduler");
            se.printStackTrace();
        }
    }

    @Override
    public QuartzTriggerHandle scheduleAsynchronousEvent(String type, Object ... parameters) {
        String jobName = this.nextUniqueName();
        String triggerName = this.nextUniqueName();
        JobDetail jobDetail = new JobDetail(jobName, null, QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)"async", (Object)new AsynchronousEvent(type, parameters));
        SimpleTrigger trigger = new SimpleTrigger(triggerName, null);
        log.info("In the scheduleAsynchronousEvent()");
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            return new QuartzTriggerHandle(triggerName);
        }
        catch (SchedulerException se) {
            log.error("Cannot Schedule a Quartz Job");
            se.printStackTrace();
            return null;
        }
    }

    @Override
    public QuartzTriggerHandle scheduleTimedEvent(String type, Schedule schedule, Object ... parameters) {
        log.info("In the scheduleTimedEvent()");
        try {
            return this.scheduleWithQuartzService(schedule, new AsynchronousEvent(type, parameters));
        }
        catch (SchedulerException se) {
            log.error("Cannot Schedule a Quartz Job");
            se.printStackTrace();
            return null;
        }
    }

    @Override
    public QuartzTriggerHandle scheduleInvocation(InvocationContext invocation, Component component) {
        log.info("In the scheduleInvocation()");
        try {
            return this.scheduleWithQuartzService(this.createSchedule(invocation), new AsynchronousInvocation(invocation, component));
        }
        catch (SchedulerException se) {
            log.error("Cannot Schedule a Quartz Job");
            se.printStackTrace();
            return null;
        }
    }

    private static Date calculateDelayedDate(long delay) {
        Date now = new Date();
        now.setTime(now.getTime() + delay);
        return now;
    }

    private QuartzTriggerHandle scheduleWithQuartzService(Schedule schedule, Asynchronous async) throws SchedulerException {
        log.info("In the scheduleWithQuartzService()");
        String jobName = this.nextUniqueName();
        String triggerName = this.nextUniqueName();
        JobDetail jobDetail = new JobDetail(jobName, null, QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)"async", (Object)async);
        if (schedule instanceof CronSchedule) {
            CronSchedule cronSchedule = (CronSchedule)schedule;
            try {
                CronTrigger trigger = new CronTrigger(triggerName, null);
                trigger.setCronExpression(cronSchedule.getCron());
                trigger.setEndTime(cronSchedule.getFinalExpiration());
                if (cronSchedule.getExpiration() != null) {
                    trigger.setStartTime(cronSchedule.getExpiration());
                } else if (cronSchedule.getDuration() != null) {
                    trigger.setStartTime(QuartzDispatcher.calculateDelayedDate(cronSchedule.getDuration()));
                }
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
            catch (Exception e) {
                log.error("Cannot submit cron job");
                e.printStackTrace();
                return null;
            }
        } else if (schedule instanceof TimerSchedule && ((TimerSchedule)schedule).getIntervalDuration() != null) {
            TimerSchedule timerSchedule = (TimerSchedule)schedule;
            if (timerSchedule.getExpiration() != null) {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null, timerSchedule.getExpiration(), timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            } else if (timerSchedule.getDuration() != null) {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null, QuartzDispatcher.calculateDelayedDate(timerSchedule.getDuration()), timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            } else {
                SimpleTrigger trigger = new SimpleTrigger(triggerName, null, null, timerSchedule.getFinalExpiration(), SimpleTrigger.REPEAT_INDEFINITELY, timerSchedule.getIntervalDuration().longValue());
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
        } else if (schedule.getExpiration() != null) {
            SimpleTrigger trigger = new SimpleTrigger(triggerName, null, schedule.getExpiration());
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else if (schedule.getDuration() != null) {
            SimpleTrigger trigger = new SimpleTrigger(triggerName, null, QuartzDispatcher.calculateDelayedDate(schedule.getDuration()));
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else {
            SimpleTrigger trigger = new SimpleTrigger(triggerName, null);
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        return new QuartzTriggerHandle(triggerName);
    }

    private String nextUniqueName() {
        return new UID().toString();
    }

    @Destroy
    public void destroy() {
        log.info("The QuartzDispatcher is shut down");
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException se) {
            log.error("Cannot shutdown the Quartz Scheduler");
            se.printStackTrace();
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public static QuartzDispatcher instance() {
        return (QuartzDispatcher)AbstractDispatcher.instance();
    }

    public static class QuartzJob
    implements Job {
        private Asynchronous async;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            log.info("Start executing Quartz job");
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            this.async = (Asynchronous)dataMap.get((Object)"async");
            this.async.execute(null);
            log.info("End executing Quartz job");
        }
    }
}

