/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.bpm.ManagedJbpmContext;
import org.jbpm.graph.exe.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.bpm.processInstanceFinder")
@Install(precedence=0, dependencies={"org.jboss.seam.bpm.jbpm"})
public class ProcessInstanceFinder {
    private String processDefinitionName;
    private String nodeName;
    private Boolean processInstanceEnded = false;
    private Boolean sortDescending = false;

    @Factory(value="org.jboss.seam.bpm.processInstanceList")
    @Transactional
    public List<ProcessInstance> getProcessInstanceList() {
        Criteria query = ManagedJbpmContext.instance().getSession().createCriteria(ProcessInstance.class);
        if (this.processInstanceEnded != null) {
            query.add(this.processInstanceEnded != false ? Restrictions.isNotNull((String)"end") : Restrictions.isNull((String)"end"));
        }
        if (this.processDefinitionName != null) {
            query.createCriteria("processDefinition").add((Criterion)Restrictions.eq((String)"name", (Object)this.processDefinitionName));
        }
        query = query.createCriteria("rootToken");
        if (this.sortDescending != null) {
            query.addOrder(this.sortDescending != false ? Order.desc((String)"nodeEnter") : Order.asc((String)"nodeEnter"));
        }
        if (this.nodeName != null) {
            query.createCriteria("node").add((Criterion)Restrictions.eq((String)"name", (Object)this.nodeName));
        }
        return query.list();
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    protected void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    protected String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    protected void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    protected Boolean isSortDescending() {
        return this.sortDescending;
    }

    protected void setSortDescending(Boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    protected Boolean getProcessInstanceEnded() {
        return this.processInstanceEnded;
    }

    protected void setProcessInstanceEnded(Boolean ended) {
        this.processInstanceEnded = ended;
    }
}

