/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import org.jboss.seam.contexts.PassivatedEntity;
import org.jboss.seam.contexts.Wrapper;

class EntityBean
implements Wrapper {
    private static final long serialVersionUID = -2884601453783925804L;
    private Object instance;
    private PassivatedEntity passivatedEntity;
    private transient boolean initialized;

    public EntityBean(Object instance) {
        this.instance = instance;
        this.initialized = true;
    }

    public Object getInstance() {
        if (!this.initialized && this.passivatedEntity != null) {
            this.instance = this.passivatedEntity.toEntityReference(true);
        }
        this.initialized = true;
        return this.instance;
    }

    public boolean passivate() {
        if (this.passivatedEntity == null || this.passivatedEntity.isVersioned()) {
            if (PassivatedEntity.isTransactionRolledBackOrMarkedRollback()) {
                this.passivatedEntity = null;
            } else {
                this.passivatedEntity = PassivatedEntity.passivateEntity(this.instance);
                if (this.passivatedEntity != null) {
                    this.instance = null;
                }
            }
            return true;
        }
        return false;
    }

    public void activate() {
        if (this.passivatedEntity != null && this.passivatedEntity.isVersioned()) {
            this.instance = this.passivatedEntity.toEntityReference(true);
            this.initialized = true;
        } else {
            this.initialized = false;
        }
    }
}

