/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.contexts.ApplicationContext;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.EventContext;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.PageContext;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.contexts.SessionContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.web.Session;

public class FacesLifecycle {
    private static ThreadLocal<PhaseId> phaseId = new ThreadLocal();
    private static final LogProvider log = Logging.getLogProvider(FacesLifecycle.class);

    public static void setPhaseId(PhaseId phase) {
        phaseId.set(phase);
    }

    public static PhaseId getPhaseId() {
        return phaseId.get();
    }

    public static void clearPhaseId() {
        FacesLifecycle.setPhaseId(null);
    }

    public static void beginRequest(ExternalContext externalContext) {
        log.debug(">>> Begin JSF request");
        Contexts.eventContext.set(new EventContext(externalContext.getRequestMap()));
        Contexts.applicationContext.set(new ApplicationContext(externalContext.getApplicationMap()));
        Contexts.sessionContext.set(new SessionContext(externalContext.getSessionMap()));
        Session session = Session.getInstance();
        if (session != null && session.isInvalidDueToNewScheme(Pages.getRequestScheme(FacesContext.getCurrentInstance()))) {
            FacesLifecycle.invalidateSession(externalContext);
        }
        Contexts.conversationContext.set(null);
    }

    public static void beginExceptionRecovery(ExternalContext externalContext) {
        log.debug(">>> Begin exception recovery");
        Contexts.applicationContext.set(new ApplicationContext(externalContext.getApplicationMap()));
        Contexts.eventContext.set(new EventContext(externalContext.getRequestMap()));
        Contexts.sessionContext.set(new SessionContext(externalContext.getSessionMap()));
        ServerConversationContext conversationContext = new ServerConversationContext(externalContext.getSessionMap());
        Contexts.conversationContext.set(conversationContext);
        Contexts.pageContext.set(null);
        Contexts.businessProcessContext.set(null);
        conversationContext.unflush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(ExternalContext externalContext) {
        log.debug("After render response, destroying contexts");
        try {
            Session session = Session.getInstance();
            boolean sessionInvalid = session != null && session.isInvalid();
            Contexts.flushAndDestroyContexts();
            if (sessionInvalid) {
                Lifecycle.clearThreadlocals();
                FacesLifecycle.clearPhaseId();
                FacesLifecycle.invalidateSession(externalContext);
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
            log.debug("<<< End JSF request");
        }
    }

    private static void invalidateSession(ExternalContext externalContext) {
        Object session = externalContext.getSession(false);
        if (session != null) {
            try {
                session.getClass().getMethod("invalidate", new Class[0]).invoke(session, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void resumeConversation(ExternalContext externalContext) {
        ServerConversationContext conversationContext = new ServerConversationContext(externalContext.getSessionMap());
        Contexts.conversationContext.set(conversationContext);
        Contexts.businessProcessContext.set(new BusinessProcessContext());
        conversationContext.unflush();
    }

    public static void resumePage() {
        Contexts.pageContext.set(new PageContext());
    }
}

