/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.ApplicationContext;
import org.jboss.seam.contexts.BasicContext;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.EventContext;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.contexts.SessionContext;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletApplicationMap;
import org.jboss.seam.servlet.ServletRequestMap;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.servlet.ServletSessionMap;
import org.jboss.seam.web.Session;

public class ServletLifecycle {
    private static final LogProvider log = Logging.getLogProvider(ServletLifecycle.class);
    private static ServletContext servletContext;

    public static ServletContext getServletContext() {
        if (servletContext == null) {
            throw new IllegalStateException("Attempted to invoke a Seam component outside the context of a web application");
        }
        return servletContext;
    }

    public static void beginRequest(HttpServletRequest request) {
        log.debug(">>> Begin web request");
        Contexts.eventContext.set(new EventContext(new ServletRequestMap((ServletRequest)request)));
        Contexts.sessionContext.set(new SessionContext(new ServletRequestSessionMap(request)));
        Contexts.applicationContext.set(new ApplicationContext(Lifecycle.getApplication()));
        Contexts.conversationContext.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(HttpServletRequest request) {
        log.debug("After request, destroying contexts");
        try {
            Session session = Session.getInstance();
            boolean sessionInvalid = session != null && session.isInvalid();
            Contexts.flushAndDestroyContexts();
            if (sessionInvalid) {
                Lifecycle.clearThreadlocals();
                request.getSession().invalidate();
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
            log.debug("<<< End web request");
        }
    }

    public static void beginInitialization() {
        log.debug(">>> Begin initialization");
        Contexts.applicationContext.set(new ApplicationContext(Lifecycle.getApplication()));
        Contexts.eventContext.set(new BasicContext(ScopeType.EVENT));
        Contexts.conversationContext.set(new BasicContext(ScopeType.CONVERSATION));
    }

    public static void beginReinitialization(HttpServletRequest request) {
        log.debug(">>> Begin re-initialization");
        Contexts.applicationContext.set(new ApplicationContext(Lifecycle.getApplication()));
        Contexts.eventContext.set(new BasicContext(ScopeType.EVENT));
        Contexts.sessionContext.set(new SessionContext(new ServletRequestSessionMap(request)));
        Contexts.conversationContext.set(new BasicContext(ScopeType.CONVERSATION));
    }

    public static void endInitialization() {
        Contexts.startup(ScopeType.APPLICATION);
        Events.instance().raiseEvent("org.jboss.seam.postInitialization", new Object[0]);
        Contexts.destroy(Contexts.getConversationContext());
        Contexts.conversationContext.set(null);
        Contexts.destroy(Contexts.getEventContext());
        Contexts.eventContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.applicationContext.set(null);
        log.debug("<<< End initialization");
    }

    public static void beginApplication(ServletContext context) {
        servletContext = context;
        Lifecycle.beginApplication(new ServletApplicationMap(context));
    }

    public static void endApplication() {
        Lifecycle.endApplication();
        servletContext = null;
    }

    public static void beginSession(HttpSession session) {
        Lifecycle.beginSession(new ServletSessionMap(session));
    }

    public static void endSession(HttpSession session) {
        Lifecycle.endSession(new ServletSessionMap(session));
    }

    public static void resumeConversation(HttpServletRequest request) {
        ServerConversationContext conversationContext = new ServerConversationContext(new ServletRequestSessionMap(request));
        Contexts.conversationContext.set(conversationContext);
        Contexts.businessProcessContext.set(new BusinessProcessContext());
        conversationContext.unflush();
    }
}

