/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="org.jboss.seam.core.conversationList")
@Install(precedence=0)
@BypassInterceptors
public class ConversationList
implements Serializable {
    private static final long serialVersionUID = -1515889862229134356L;
    private List<ConversationEntry> conversationEntryList;

    @Create
    public void createConversationEntryList() {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries == null) {
            this.conversationEntryList = Collections.EMPTY_LIST;
        } else {
            TreeSet<ConversationEntry> orderedEntries = new TreeSet<ConversationEntry>();
            orderedEntries.addAll(conversationEntries.getConversationEntries());
            this.conversationEntryList = new ArrayList<ConversationEntry>(conversationEntries.size());
            for (ConversationEntry entry : orderedEntries) {
                if (!entry.isDisplayable() || Session.instance().isInvalid()) continue;
                this.conversationEntryList.add(entry);
            }
        }
    }

    @Unwrap
    public List<ConversationEntry> getConversationEntryList() {
        return this.conversationEntryList;
    }
}

