/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Page;
import org.jboss.seam.navigation.Pages;

@Name(value="org.jboss.seam.core.conversationPropagation")
@Scope(value=ScopeType.EVENT)
@BypassInterceptors
@Install(precedence=0)
public class ConversationPropagation {
    private static final LogProvider log = Logging.getLogProvider(ConversationPropagation.class);
    private String conversationId;
    private String parentConversationId;
    private boolean validateLongRunningConversation;
    private String propagationType;

    public void restoreConversationId(Map parameters) {
        this.restoreNaturalConversationId(parameters);
        this.restoreSyntheticConversationId(parameters);
        this.restorePageContextConversationId();
        this.propagationType = this.getPropagationFromRequestParameter(parameters);
        this.handlePropagationType(parameters);
    }

    private void handlePropagationType(Map parameters) {
        if ("none".equals(this.propagationType)) {
            this.conversationId = null;
            this.parentConversationId = null;
            this.validateLongRunningConversation = false;
        } else if ("end".equals(this.propagationType)) {
            this.validateLongRunningConversation = false;
        }
    }

    private void restorePageContextConversationId() {
        if (Contexts.isPageContextActive() && ConversationPropagation.isMissing(this.conversationId)) {
            FacesPage page = FacesPage.instance();
            this.conversationId = page.getConversationId();
            this.parentConversationId = null;
            this.validateLongRunningConversation = page.isConversationLongRunning();
        } else {
            log.debug("Found conversation id in request parameter: " + this.conversationId);
        }
    }

    private void restoreNaturalConversationId(Map parameters) {
        String viewId = Pages.getCurrentViewId();
        if (viewId != null) {
            Page page = Pages.instance().getPage(viewId);
            this.conversationId = page.getConversationIdParameter().getRequestConversationId(parameters);
        }
    }

    private void restoreSyntheticConversationId(Map parameters) {
        Manager manager = Manager.instance();
        if (ConversationPropagation.isMissing(this.conversationId)) {
            this.conversationId = ConversationPropagation.getRequestParameterValue(parameters, manager.getConversationIdParameter());
        }
        if (ConversationPropagation.isMissing(this.parentConversationId)) {
            this.parentConversationId = ConversationPropagation.getRequestParameterValue(parameters, manager.getParentConversationIdParameter());
        }
    }

    private String getPropagationFromRequestParameter(Map parameters) {
        Object type = parameters.get("conversationPropagation");
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            return (String)type;
        }
        return ((String[])type)[0];
    }

    private static boolean isMissing(String storedConversationId) {
        return storedConversationId == null || "".equals(storedConversationId);
    }

    public static String getRequestParameterValue(Map parameters, String parameterName) {
        Object object = parameters.get(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String[] values = (String[])object;
        if (values.length != 1) {
            throw new IllegalArgumentException("expected exactly one value for conversationId request parameter");
        }
        return values[0];
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getParentConversationId() {
        return this.parentConversationId;
    }

    public void setParentConversationId(String parentConversationId) {
        this.parentConversationId = parentConversationId;
    }

    public boolean isValidateLongRunningConversation() {
        return this.validateLongRunningConversation;
    }

    public void setValidateLongRunningConversation(boolean validateLongRunningConversation) {
        this.validateLongRunningConversation = validateLongRunningConversation;
    }

    public static ConversationPropagation instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        return (ConversationPropagation)Component.getInstance(ConversationPropagation.class, ScopeType.EVENT);
    }

    public String getPropagationType() {
        return this.propagationType;
    }

    public void setPropagationType(String propagationType) {
        this.propagationType = propagationType;
    }
}

