/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="org.jboss.seam.core.conversationStack")
@Install(precedence=0)
@BypassInterceptors
public class ConversationStack
implements Serializable {
    private static final long serialVersionUID = 7941458529299691801L;
    private List<ConversationEntry> conversationEntryStack;

    @Create
    public void createConversationEntryStack() {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries == null) {
            this.conversationEntryStack = Collections.EMPTY_LIST;
        } else {
            ConversationEntry currentConversationEntry = Manager.instance().getCurrentConversationEntry();
            if (currentConversationEntry != null) {
                List<String> idStack = currentConversationEntry.getConversationIdStack();
                this.conversationEntryStack = new ArrayList<ConversationEntry>(conversationEntries.size());
                ListIterator<String> ids = idStack.listIterator(idStack.size());
                while (ids.hasPrevious()) {
                    ConversationEntry entry = conversationEntries.getConversationEntry(ids.previous());
                    if (!entry.isDisplayable() || Session.instance().isInvalid()) continue;
                    this.conversationEntryStack.add(entry);
                }
            }
        }
    }

    @Unwrap
    public List<ConversationEntry> getConversationEntryStack() {
        return this.conversationEntryStack;
    }
}

