/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.drools;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class RuleBase {
    private static final LogProvider log = Logging.getLogProvider(RuleBase.class);
    private String[] ruleFiles;
    private String dslFile;
    private org.drools.RuleBase ruleBase;

    @Create
    public void compileRuleBase() throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setCompiler(1);
        PackageBuilder builder = new PackageBuilder(conf);
        if (this.ruleFiles != null) {
            for (String ruleFile : this.ruleFiles) {
                log.info("parsing rules: " + ruleFile);
                InputStream stream = ResourceLoader.instance().getResourceAsStream(ruleFile);
                if (stream == null) {
                    throw new IllegalStateException("could not locate rule file: " + ruleFile);
                }
                InputStreamReader drlReader = new InputStreamReader(stream);
                if (this.dslFile == null) {
                    builder.addPackageFromDrl((Reader)drlReader);
                } else {
                    InputStreamReader dslReader = new InputStreamReader(ResourceLoader.instance().getResourceAsStream(this.dslFile));
                    builder.addPackageFromDrl((Reader)drlReader, (Reader)dslReader);
                }
                if (!builder.hasErrors()) continue;
                log.error("errors parsing rules in: " + ruleFile);
                for (ParserError error : (List)builder.getErrors()) {
                    log.error(error.getMessage() + " (" + ruleFile + ':' + error.getRow() + ')');
                }
            }
        }
        this.ruleBase = RuleBaseFactory.newRuleBase();
        this.ruleBase.addPackage(builder.getPackage());
    }

    @Unwrap
    public org.drools.RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public String[] getRuleFiles() {
        return this.ruleFiles;
    }

    public void setRuleFiles(String[] ruleFiles) {
        this.ruleFiles = ruleFiles;
    }

    public String getDslFile() {
        return this.dslFile;
    }

    public void setDslFile(String dslFile) {
        this.dslFile = dslFile;
    }
}

