/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.exception.AnnotationErrorHandler;
import org.jboss.seam.exception.AnnotationRedirectHandler;
import org.jboss.seam.exception.ConfigErrorHandler;
import org.jboss.seam.exception.ConfigRedirectHandler;
import org.jboss.seam.exception.DebugPageHandler;
import org.jboss.seam.exception.ExceptionHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@Name(value="org.jboss.seam.exception.exceptions")
public class Exceptions {
    private static final LogProvider log = Logging.getLogProvider(Exceptions.class);
    private List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();

    public void handle(Exception e) throws Exception {
        if (Contexts.isConversationContextActive()) {
            Contexts.getConversationContext().set("org.jboss.seam.exception", e);
        }
        ArrayList<Exception> causes = new ArrayList<Exception>();
        Exception cause = e;
        while (cause != null) {
            causes.add(cause);
            cause = EJB.getCause(cause);
        }
        for (ExceptionHandler eh : this.exceptionHandlers) {
            for (int i = causes.size() - 1; i >= 0; --i) {
                Exception cause2 = (Exception)causes.get(i);
                if (!eh.isHandler(cause2)) continue;
                if (Contexts.isConversationContextActive()) {
                    Contexts.getConversationContext().set("org.jboss.seam.handledException", cause2);
                }
                eh.handle(cause2);
                Events.instance().raiseEvent("org.jboss.seam.exceptionHandled." + cause2.getClass().getName(), cause2);
                Events.instance().raiseEvent("org.jboss.seam.exceptionHandled", cause2);
                return;
            }
        }
        Events.instance().raiseEvent("org.jboss.seam.exceptionNotHandled", e);
        throw e;
    }

    @Create
    public void initialize() throws Exception {
        ArrayList<ExceptionHandler> deferredHandlers = new ArrayList<ExceptionHandler>();
        deferredHandlers.add(this.parse("/WEB-INF/exceptions.xml"));
        for (String pageFile : Pages.instance().getResources()) {
            deferredHandlers.add(this.parse(pageFile));
        }
        this.addHandler(new AnnotationRedirectHandler());
        this.addHandler(new AnnotationErrorHandler());
        if (Init.instance().isDebug()) {
            this.addHandler(new DebugPageHandler());
        }
        for (ExceptionHandler handler : deferredHandlers) {
            this.addHandler(handler);
        }
    }

    private void addHandler(ExceptionHandler handler) {
        if (handler != null) {
            this.exceptionHandlers.add(handler);
        }
    }

    private ExceptionHandler parse(String fileName) throws DocumentException, ClassNotFoundException {
        ExceptionHandler anyhandler = null;
        InputStream stream = ResourceLoader.instance().getResourceAsStream(fileName);
        if (stream != null) {
            log.debug("reading exception mappings from " + fileName);
            List elements = XML.getRootElement(stream).elements("exception");
            for (Element exception : elements) {
                String className = exception.attributeValue("class");
                if (className == null) {
                    anyhandler = this.createHandler(exception, Exception.class);
                    continue;
                }
                ExceptionHandler handler = this.createHandler(exception, Reflections.classForName(className));
                if (handler == null) continue;
                this.exceptionHandlers.add(handler);
            }
        }
        return anyhandler;
    }

    private ExceptionHandler createHandler(Element exception, Class clazz) {
        boolean endConversation = exception.elementIterator("end-conversation").hasNext();
        Element redirect = exception.element("redirect");
        if (redirect != null) {
            String viewId = redirect.attributeValue("view-id");
            Element messageElement = redirect.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(severityName.toUpperCase());
            return new ConfigRedirectHandler(viewId, clazz, endConversation, message, severity);
        }
        Element error = exception.element("http-error");
        if (error != null) {
            String errorCode = error.attributeValue("error-code");
            int code = Strings.isEmpty(errorCode) ? 500 : Integer.parseInt(errorCode);
            Element messageElement = error.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            return new ConfigErrorHandler(message, endConversation, clazz, code);
        }
        return null;
    }

    public List<ExceptionHandler> getHandlers() {
        return this.exceptionHandlers;
    }

    public static Exceptions instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Exceptions)Component.getInstance(Exceptions.class, ScopeType.APPLICATION);
    }
}

