/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationList;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.ConversationStack;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.faces.Switcher;
import org.jboss.seam.faces.Validation;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.Reflections;

public class SeamPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -9127555729455066493L;
    private static final LogProvider log = Logging.getLogProvider(SeamPhaseListener.class);
    private static boolean exists = false;
    private static final Method SET_RENDER_PARAMETER;
    private static final Class ACTION_RESPONSE;
    private static final Class PORTLET_REQUEST;

    public SeamPhaseListener() {
        if (exists) {
            log.warn("There should only be one Seam phase listener per application");
        }
        exists = true;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        log.trace("before phase: " + event.getPhaseId());
        FacesLifecycle.setPhaseId(event.getPhaseId());
        try {
            if (SeamPhaseListener.isPortletRequest(event)) {
                this.beforePortletPhase(event);
            } else {
                this.beforeServletPhase(event);
            }
            this.raiseEventsBeforePhase(event);
        }
        catch (Exception e) {
            log.error("uncaught exception", e);
            try {
                Exceptions.instance().handle(e);
            }
            catch (Exception ehe) {
                log.error("swallowing exception", e);
            }
        }
    }

    private void beforeServletPhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.beforeRestoreView(event.getFacesContext());
        }
        this.handleTransactionsBeforePhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRender(event);
        }
    }

    private void beforePortletPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW || event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRestoreView(facesContext);
        }
        this.handleTransactionsBeforePhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRestoreView(facesContext);
            this.beforeRender(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        log.trace("after phase: " + event.getPhaseId());
        try {
            this.raiseEventsAfterPhase(event);
            if (SeamPhaseListener.isPortletRequest(event)) {
                this.afterPortletPhase(event);
            } else {
                this.afterServletPhase(event);
            }
        }
        catch (Exception e) {
            log.error("uncaught exception", e);
            try {
                Exceptions.instance().handle(e);
            }
            catch (Exception ehe) {
                log.error("swallowing exception", e);
            }
        }
        FacesLifecycle.clearPhaseId();
    }

    private void afterServletPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.afterRestoreView(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            this.afterInvokeApplication();
        } else if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS) {
            this.afterProcessValidations(event.getFacesContext());
        }
        FacesMessages.afterPhase();
        this.handleTransactionsAfterPhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRender(facesContext);
        } else if (facesContext.getResponseComplete()) {
            this.afterResponseComplete(facesContext);
        }
    }

    private void afterPortletPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.afterRestoreView(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            this.afterInvokeApplication();
        } else if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS) {
            this.afterProcessValidations(event.getFacesContext());
        }
        FacesMessages.afterPhase();
        this.handleTransactionsAfterPhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRender(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION || facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            Manager manager = Manager.instance();
            manager.beforeRedirect();
            if (manager.isLongRunningConversation()) {
                SeamPhaseListener.setPortletRenderParameter(facesContext.getExternalContext().getResponse(), manager.getConversationIdParameter(), manager.getCurrentConversationId());
            }
            this.afterResponseComplete(facesContext);
        }
    }

    private static void setPortletRenderParameter(Object response, String conversationIdParameter, String conversationId) {
        if (ACTION_RESPONSE.isInstance(response)) {
            Reflections.invokeAndWrap(SET_RENDER_PARAMETER, response, conversationIdParameter, conversationId);
        }
    }

    private static boolean isPortletRequest(PhaseEvent event) {
        return PORTLET_REQUEST != null && PORTLET_REQUEST.isInstance(event.getFacesContext().getExternalContext().getRequest());
    }

    public void handleTransactionsBeforePhase(PhaseEvent event) {
        if (Init.instance().isTransactionManagementEnabled()) {
            boolean beginTran;
            PhaseId phaseId = event.getPhaseId();
            boolean bl = phaseId == PhaseId.RENDER_RESPONSE || phaseId == (Transaction.instance().isConversationContextRequired() ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.RESTORE_VIEW) ? true : (beginTran = false);
            if (beginTran) {
                this.begin(phaseId);
            }
        }
    }

    public void handleTransactionsAfterPhase(PhaseEvent event) {
        if (Init.instance().isTransactionManagementEnabled()) {
            boolean commitTran;
            PhaseId phaseId = event.getPhaseId();
            boolean bl = commitTran = phaseId == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || event.getFacesContext().getResponseComplete() || phaseId == PhaseId.RENDER_RESPONSE;
            if (commitTran) {
                this.commitOrRollback(phaseId);
            }
        }
    }

    protected void handleTransactionsAfterPageActions(PhaseEvent event) {
        if (Init.instance().isTransactionManagementEnabled()) {
            this.commitOrRollback(PhaseId.INVOKE_APPLICATION);
            if (!event.getFacesContext().getResponseComplete()) {
                this.begin(PhaseId.INVOKE_APPLICATION);
            }
        }
    }

    protected void afterInvokeApplication() {
        if (Init.instance().isTransactionManagementEnabled()) {
            this.addTransactionFailedMessage();
        }
    }

    protected void afterProcessValidations(FacesContext facesContext) {
        Validation.instance().afterProcessValidations(facesContext);
    }

    protected void beforeRestoreView(FacesContext facesContext) {
        FacesLifecycle.beginRequest(facesContext.getExternalContext());
    }

    protected void afterRestoreView(FacesContext facesContext) {
        FacesLifecycle.resumePage();
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        ConversationPropagation.instance().restoreConversationId(parameters);
        boolean conversationFound = Manager.instance().restoreConversation();
        FacesLifecycle.resumeConversation(facesContext.getExternalContext());
        if (!conversationFound) {
            Pages.instance().redirectToNoConversationView();
        }
        Manager.instance().handleConversationPropagation(parameters);
        if (Init.instance().isJbpmInstalled()) {
            Pageflow.instance().validatePageflow();
        }
        if (log.isDebugEnabled()) {
            log.debug("After restoring conversation context: " + Contexts.getConversationContext());
        }
        Pages.instance().postRestore(facesContext);
    }

    public void raiseEventsBeforePhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.beforePhase", event);
        }
    }

    public void raiseEventsAfterPhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.afterPhase", event);
        }
    }

    protected void addTransactionFailedMessage() {
        try {
            if (Transaction.instance().isRolledBackOrMarkedRollback()) {
                FacesMessages.instance().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_WARN, "org.jboss.seam.TransactionFailed", "Transaction failed", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void beforeRender(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (Contexts.isPageContextActive()) {
            Context pageContext = Contexts.getPageContext();
            pageContext.flush();
            pageContext.remove(Seam.getComponentName(ConversationList.class));
            pageContext.remove(Seam.getComponentName(Switcher.class));
            pageContext.remove(Seam.getComponentName(ConversationStack.class));
        }
        this.preRenderPage(event);
        if (facesContext.getResponseComplete()) {
            if (Init.instance().isMyFacesLifecycleBug()) {
                FacesLifecycle.endRequest(facesContext.getExternalContext());
            }
        } else {
            FacesMessages.instance().beforeRenderResponse();
            FacesManager.instance().prepareBackswitch(facesContext);
        }
        FacesPage.instance().storeConversation();
        FacesPage.instance().storePageflow();
        PersistenceContexts persistenceContexts = PersistenceContexts.instance();
        if (persistenceContexts != null) {
            persistenceContexts.beforeRender();
        }
    }

    protected void afterRender(FacesContext facesContext) {
        FacesManager.instance().prepareBackswitch(facesContext);
        PersistenceContexts persistenceContexts = PersistenceContexts.instance();
        if (persistenceContexts != null) {
            persistenceContexts.afterRender();
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Manager.instance().endRequest(externalContext.getSessionMap());
        FacesLifecycle.endRequest(externalContext);
    }

    protected void afterResponseComplete(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Manager.instance().endRequest(externalContext.getSessionMap());
        FacesLifecycle.endRequest(facesContext.getExternalContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preRenderPage(PhaseEvent event) {
        if (Pages.isDebugPage()) {
            return false;
        }
        FacesLifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        boolean actionsWereCalled = false;
        try {
            boolean bl = actionsWereCalled = Pages.instance().preRender(event.getFacesContext());
            return bl;
        }
        finally {
            FacesLifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
            if (actionsWereCalled) {
                FacesMessages.afterPhase();
                this.handleTransactionsAfterPageActions(event);
            }
        }
    }

    void begin(PhaseId phaseId) {
        try {
            if (!Transaction.instance().isActiveOrMarkedRollback()) {
                log.debug("beginning transaction prior to phase: " + phaseId);
                Transaction.instance().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    void commitOrRollback(PhaseId phaseId) {
        try {
            if (Transaction.instance().isActive()) {
                log.debug("committing transaction after phase: " + phaseId);
                Transaction.instance().commit();
            } else if (Transaction.instance().isRolledBackOrMarkedRollback()) {
                log.debug("rolling back transaction after phase: " + phaseId);
                Transaction.instance().rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }

    static {
        Method method = null;
        Class<?> actionResponseClass = null;
        Class<?> portletRequestClass = null;
        try {
            Class[] parameterTypes = new Class[]{String.class, String.class};
            actionResponseClass = Class.forName("javax.portlet.ActionResponse");
            portletRequestClass = Class.forName("javax.portlet.PortletRequest");
            method = actionResponseClass.getMethod("setRenderParameter", parameterTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SET_RENDER_PARAMETER = method;
        ACTION_RESPONSE = actionResponseClass;
        PORTLET_REQUEST = portletRequestClass;
    }
}

