/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.core.Expressions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskControl {
    private boolean isBeginTask;
    private boolean isStartTask;
    private boolean isEndTask;
    private Expressions.ValueExpression taskId;
    private String transition;

    public void beginOrEndTask() {
        if (this.endTask()) {
            BusinessProcess.instance().validateTask();
            BusinessProcess.instance().endTask(this.transition);
        }
        if (this.beginTask() || this.startTask()) {
            Long taskId;
            Object id = this.taskId.getValue();
            if (id == null) {
                throw new IllegalStateException("task id may not be null");
            }
            if (id instanceof Long) {
                taskId = (Long)id;
            } else if (id instanceof String) {
                taskId = new Long((String)id);
            } else {
                throw new IllegalArgumentException("task id must be a string or long");
            }
            BusinessProcess.instance().resumeTask(taskId);
        }
        if (this.startTask()) {
            BusinessProcess.instance().startTask();
        }
    }

    private boolean beginTask() {
        return this.isBeginTask && this.taskId.getValue() != null;
    }

    private boolean startTask() {
        return this.isStartTask && this.taskId.getValue() != null;
    }

    private boolean endTask() {
        return this.isEndTask;
    }

    public boolean isBeginTask() {
        return this.isBeginTask;
    }

    public void setBeginTask(boolean isBeginTask) {
        this.isBeginTask = isBeginTask;
    }

    public boolean isEndTask() {
        return this.isEndTask;
    }

    public void setEndTask(boolean isEndTask) {
        this.isEndTask = isEndTask;
    }

    public boolean isStartTask() {
        return this.isStartTask;
    }

    public void setStartTask(boolean isStartTask) {
        this.isStartTask = isStartTask;
    }

    public void setTaskId(Expressions.ValueExpression<String> taskId) {
        this.taskId = taskId;
    }

    public Expressions.ValueExpression<String> getTaskId() {
        return this.taskId;
    }

    public String getTransition() {
        return this.transition;
    }

    public void setTransition(String transition) {
        this.transition = transition;
    }
}

