/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.VersionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.Filter;
import org.jboss.seam.persistence.HibernateSessionProxy;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceProvider;

@Name(value="org.jboss.seam.persistence.persistenceProvider")
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Install(precedence=10, classDependencies={"org.hibernate.Session"}, genericDependencies={ManagedPersistenceContext.class})
public class HibernatePersistenceProvider
extends PersistenceProvider {
    private static Log log = Logging.getLog(HibernatePersistenceProvider.class);
    private static Constructor FULL_TEXT_SESSION_PROXY_CONSTRUCTOR;
    private static Method FULL_TEXT_SESSION_CONSTRUCTOR;

    static Session proxySession(Session session) throws Exception {
        if (FULL_TEXT_SESSION_PROXY_CONSTRUCTOR == null) {
            return new HibernateSessionProxy(session);
        }
        return (Session)FULL_TEXT_SESSION_PROXY_CONSTRUCTOR.newInstance(FULL_TEXT_SESSION_CONSTRUCTOR.invoke(null, session));
    }

    public Object proxyDelegate(Object delegate) {
        try {
            return HibernatePersistenceProvider.proxySession((Session)delegate);
        }
        catch (Exception e) {
            throw new RuntimeException("could not proxy delegate", e);
        }
    }

    public void setFlushModeManual(EntityManager entityManager) {
        this.getSession(entityManager).setFlushMode(FlushMode.MANUAL);
    }

    public boolean isDirty(EntityManager entityManager) {
        return this.getSession(entityManager).isDirty();
    }

    public Object getId(Object bean, EntityManager entityManager) {
        return this.getSession(entityManager).getIdentifier(bean);
    }

    public Object getVersion(Object bean, EntityManager entityManager) {
        return HibernatePersistenceProvider.getVersion(bean, this.getSession(entityManager));
    }

    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        HibernatePersistenceProvider.checkVersion(bean, this.getSession(entityManager), oldVersion, version);
    }

    public void enableFilter(Filter f, EntityManager entityManager) {
        org.hibernate.Filter filter = this.getSession(entityManager).enableFilter(f.getName());
        for (Map.Entry<String, Expressions.ValueExpression> me : f.getParameters().entrySet()) {
            filter.setParameter(me.getKey(), me.getValue().getValue());
        }
        filter.validate();
    }

    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        this.getSession(entityManager).getTransaction().registerSynchronization(sync);
        return true;
    }

    public FlushModeType getRenderFlushMode() {
        return FlushModeType.MANUAL;
    }

    private Session getSession(EntityManager entityManager) {
        return (Session)entityManager.getDelegate();
    }

    public static void checkVersion(Object value, Session session, Object oldVersion, Object version) {
        ClassMetadata classMetadata = HibernatePersistenceProvider.getClassMetadata(value, session);
        VersionType versionType = (VersionType)classMetadata.getPropertyTypes()[classMetadata.getVersionProperty()];
        if (!versionType.isEqual(oldVersion, version)) {
            throw new StaleStateException("current database version number does not match passivated version number");
        }
    }

    public static Object getVersion(Object value, Session session) {
        ClassMetadata classMetadata = HibernatePersistenceProvider.getClassMetadata(value, session);
        return classMetadata != null && classMetadata.isVersioned() ? classMetadata.getVersion(value, EntityMode.POJO) : null;
    }

    private static ClassMetadata getClassMetadata(Object value, Session session) {
        Class entityClass = Seam.getEntityClass(value.getClass());
        ClassMetadata classMetadata = null;
        if (entityClass != null && (classMetadata = session.getSessionFactory().getClassMetadata(entityClass)) == null) {
            throw new IllegalArgumentException("Could not find ClassMetadata object for entity class: " + entityClass.getName());
        }
        return classMetadata;
    }

    static {
        try {
            Class<?> searchClass = Class.forName("org.hibernate.search.Search");
            FULL_TEXT_SESSION_CONSTRUCTOR = searchClass.getDeclaredMethod("createFullTextSession", Session.class);
            Class<?> fullTextSessionProxyClass = Class.forName("org.jboss.seam.persistence.FullTextHibernateSessionProxy");
            Class<?> fullTextSessionClass = Class.forName("org.hibernate.search.FullTextSession");
            FULL_TEXT_SESSION_PROXY_CONSTRUCTOR = fullTextSessionProxyClass.getDeclaredConstructor(fullTextSessionClass);
            log.debug((Object)"Hibernate Search is available :-)", new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)"no Hibernate Search, sorry :-(", e, new Object[0]);
        }
    }
}

