/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.drools.FactHandle;
import org.drools.ObjectFilter;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectFilter;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.PermissionCheck;
import org.jboss.seam.security.Role;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@BypassInterceptors
@Install(precedence=10, classDependencies={"org.drools.WorkingMemory"})
@Startup
public class RuleBasedIdentity
extends Identity {
    public static final String RULES_COMPONENT_NAME = "securityRules";
    private static final LogProvider log = Logging.getLogProvider(RuleBasedIdentity.class);
    private WorkingMemory securityContext;
    private RuleBase securityRules;

    public void create() {
        super.create();
        this.initSecurityContext();
    }

    protected void initSecurityContext() {
        if (this.securityRules == null) {
            this.securityRules = (RuleBase)Component.getInstance(RULES_COMPONENT_NAME, true);
        }
        if (this.securityRules != null) {
            this.securityContext = this.securityRules.newStatefulSession(false);
        }
        if (this.securityContext == null) {
            log.warn("no security rule base available - please install a RuleBase with the name 'securityRules' if permission checks are required.");
        }
    }

    protected void postAuthenticate() {
        super.postAuthenticate();
        WorkingMemory securityContext = this.getSecurityContext();
        if (securityContext != null) {
            for (Principal p : this.getSubject().getPrincipals()) {
                if (!(p instanceof Group) || !"Roles".equals(((Group)p).getName())) continue;
                Enumeration e = ((Group)p).members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    securityContext.assertObject((Object)new Role(role.getName()));
                }
            }
            securityContext.assertObject((Object)this.getPrincipal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(String name, String action, Object ... arg) {
        WorkingMemory securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(name, action);
        WorkingMemory workingMemory = securityContext;
        synchronized (workingMemory) {
            handles.add(securityContext.assertObject((Object)check));
            for (int i = 0; i < arg.length; ++i) {
                if (i == 0 && arg[0] instanceof Collection) {
                    for (Object value : (Collection)arg[i]) {
                        if (securityContext.getFactHandle(value) != null) continue;
                        handles.add(securityContext.assertObject(value));
                    }
                    continue;
                }
                handles.add(securityContext.assertObject(arg[i]));
            }
            securityContext.fireAllRules();
            for (FactHandle handle : handles) {
                securityContext.retractObject(handle);
            }
        }
        return check.isGranted();
    }

    protected void unAuthenticate() {
        WorkingMemory securityContext = this.getSecurityContext();
        if (securityContext != null) {
            Iterator iter = securityContext.iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
            while (iter.hasNext()) {
                this.getSecurityContext().retractObject(securityContext.getFactHandle(iter.next()));
            }
        }
        super.unAuthenticate();
    }

    public boolean addRole(String role) {
        WorkingMemory securityContext;
        if (super.addRole(role) && (securityContext = this.getSecurityContext()) != null) {
            this.getSecurityContext().assertObject((Object)new Role(role));
            return true;
        }
        return false;
    }

    public void removeRole(String role) {
        WorkingMemory securityContext = this.getSecurityContext();
        if (securityContext != null) {
            Iterator iter = securityContext.iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
            while (iter.hasNext()) {
                Role r = (Role)iter.next();
                if (!r.getName().equals(role)) continue;
                FactHandle fh = this.getSecurityContext().getFactHandle((Object)r);
                this.getSecurityContext().retractObject(fh);
                break;
            }
        }
        super.removeRole(role);
    }

    public WorkingMemory getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(WorkingMemory securityContext) {
        this.securityContext = securityContext;
    }

    public RuleBase getSecurityRules() {
        return this.securityRules;
    }

    public void setSecurityRules(RuleBase securityRules) {
        this.securityRules = securityRules;
    }
}

