/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.text;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.text.SeamTextParserTokenTypes;

public class SeamTextParser
extends LLkParser
implements SeamTextParserTokenTypes {
    private Set htmlElements = new HashSet<String>(Arrays.asList("a", "p", "q", "code", "pre", "table", "tr", "td", "th", "ul", "ol", "li", "b", "i", "u", "tt", "del", "em", "hr", "br", "div", "span", "h1", "h2", "h3", "h4", "img", "object", "param", "embed"));
    private Set htmlAttributes = new HashSet<String>(Arrays.asList("src", "href", "lang", "class", "id", "style", "width", "height", "name", "value", "type", "wmode"));
    private StringBuilder mainBuilder;
    private StringBuilder builder = this.mainBuilder = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WORD", "PUNCTUATION", "ESCAPE", "STAR", "SLASH", "BAR", "HAT", "PLUS", "EQ", "HASH", "TWIDDLE", "UNDERSCORE", "OPEN", "CLOSE", "QUOTE", "GT", "LT", "DOUBLEQUOTE", "AMPERSAND", "BACKTICK", "SPACE", "NEWLINE"};
    public static final BitSet _tokenSet_0 = new BitSet(SeamTextParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SeamTextParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SeamTextParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SeamTextParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(SeamTextParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(SeamTextParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(SeamTextParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(SeamTextParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(SeamTextParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(SeamTextParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(SeamTextParser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(SeamTextParser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(SeamTextParser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(SeamTextParser.mk_tokenSet_13());

    public String toString() {
        return this.builder.toString();
    }

    private void append(String ... strings) {
        for (String string : strings) {
            this.builder.append(string);
        }
    }

    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c) != string.lastIndexOf(c);
    }

    private void validateElement(Token t) throws NoViableAltException {
        if (!this.htmlElements.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void validateAttribute(Token t) throws NoViableAltException {
        if (!this.htmlAttributes.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    protected String linkTag(String description, String url) {
        return "<a href=\"" + url + "\" styleClass=\"seamTextLink\">" + description + "</a>";
    }

    protected String macroInclude(String macroName) {
        return "";
    }

    protected SeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected SeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public SeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        try {
            while (this.LA(1) == 25) {
                this.newline();
            }
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: 
                case 21: 
                case 23: 
                case 24: {
                    switch (this.LA(1)) {
                        case 11: {
                            this.heading();
                            while (this.LA(1) == 25) {
                                this.newline();
                            }
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 24: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.text();
                    while (this.LA(1) == 11) {
                        this.heading();
                        while (this.LA(1) == 25) {
                            this.newline();
                        }
                        this.text();
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        Token n = null;
        try {
            n = this.LT(1);
            this.match(25);
            this.append(n.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void heading() throws RecognitionException, TokenStreamException {
        try {
            if (this.LA(1) == 11 && _tokenSet_2.member(this.LA(2))) {
                this.h1();
            } else if (this.LA(1) == 11 && this.LA(2) == 11 && _tokenSet_2.member(this.LA(3))) {
                this.h2();
            } else if (this.LA(1) == 11 && this.LA(2) == 11 && this.LA(3) == 11 && _tokenSet_2.member(this.LA(4))) {
                this.h3();
            } else if (this.LA(1) == 11 && this.LA(2) == 11 && this.LA(3) == 11 && this.LA(4) == 11) {
                this.h4();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
    }

    public final void text() throws RecognitionException, TokenStreamException {
        try {
            int _cnt17 = 0;
            while (true) {
                if (!_tokenSet_4.member(this.LA(1))) {
                    if (_cnt17 < 1) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 24: {
                        this.paragraph();
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 21: 
                    case 23: {
                        this.special();
                        break;
                    }
                    case 20: {
                        this.html();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 25) {
                    this.newline();
                }
                ++_cnt17;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
    }

    public final void paragraph() throws RecognitionException, TokenStreamException {
        try {
            this.append("<p>\n");
            int _cnt22 = 0;
            while (true) {
                if (!_tokenSet_2.member(this.LA(1))) {
                    if (_cnt22 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.line();
                this.newlineOrEof();
                ++_cnt22;
            }
            this.append("</p>\n");
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void special() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 23: {
                    this.preformatted();
                    break;
                }
                case 21: {
                    this.quoted();
                    break;
                }
                case 12: 
                case 13: {
                    this.list();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void html() throws RecognitionException, TokenStreamException {
        try {
            this.openTag();
            while (true) {
                if (this.LA(1) == 24 && (this.LA(2) == 8 || this.LA(2) == 19 || this.LA(2) == 24)) {
                    this.space();
                    continue;
                }
                if (this.LA(1) != 24 || this.LA(2) != 4) break;
                this.space();
                this.attribute();
            }
            switch (this.LA(1)) {
                case 19: {
                    this.beforeBody();
                    this.body();
                    this.closeTagWithBody();
                    break;
                }
                case 8: {
                    this.closeTagWithNoBody();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void preformatted() throws RecognitionException, TokenStreamException {
        try {
            this.match(23);
            this.append("<pre>");
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: {
                        this.word();
                        continue block11;
                    }
                    case 5: {
                        this.punctuation();
                        continue block11;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.specialChars();
                        continue block11;
                    }
                    case 16: 
                    case 17: {
                        this.moreSpecialChars();
                        continue block11;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        this.htmlSpecialChars();
                        continue block11;
                    }
                    case 24: {
                        this.space();
                        continue block11;
                    }
                    case 25: {
                        this.newline();
                        continue block11;
                    }
                }
                break;
            }
            this.match(23);
            this.append("</pre>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void quoted() throws RecognitionException, TokenStreamException {
        try {
            this.match(21);
            this.append("<q>");
            block10: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        continue block10;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: {
                        this.formatted();
                        continue block10;
                    }
                    case 23: {
                        this.preformatted();
                        continue block10;
                    }
                    case 20: {
                        this.html();
                        continue block10;
                    }
                    case 12: 
                    case 13: {
                        this.list();
                        this.newline();
                        continue block10;
                    }
                    case 25: {
                        this.newline();
                        continue block10;
                    }
                }
                break;
            }
            this.match(21);
            this.append("</q>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void list() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 13: {
                    this.olist();
                    break;
                }
                case 12: {
                    this.ulist();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 25: {
                    this.newline();
                    break;
                }
                case 1: {
                    this.match(1);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void line() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 16: 
                case 24: {
                    this.plain();
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: {
                    this.formatted();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            block13: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        continue block13;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: {
                        this.formatted();
                        continue block13;
                    }
                    case 23: {
                        this.preformatted();
                        continue block13;
                    }
                    case 21: {
                        this.quoted();
                        continue block13;
                    }
                    case 20: {
                        this.html();
                        continue block13;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: {
                    this.word();
                    break;
                }
                case 5: {
                    this.punctuation();
                    break;
                }
                case 6: {
                    this.escape();
                    break;
                }
                case 24: {
                    this.space();
                    break;
                }
                default: {
                    if (this.LA(1) == 16 && _tokenSet_9.member(this.LA(2))) {
                        this.link();
                        break;
                    }
                    if (this.LA(1) == 16 && this.LA(2) == 20) {
                        this.macro();
                        break;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void formatted() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 7: {
                    this.bold();
                    break;
                }
                case 15: {
                    this.underline();
                    break;
                }
                case 8: {
                    this.italic();
                    break;
                }
                case 9: {
                    this.monospace();
                    break;
                }
                case 10: {
                    this.superscript();
                    break;
                }
                case 14: {
                    this.deleted();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void bold() throws RecognitionException, TokenStreamException {
        try {
            this.match(7);
            this.append("<b>");
            int _cnt43 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        break;
                    }
                    case 15: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 14: {
                        this.deleted();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt43 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt43;
            }
            this.match(7);
            this.append("</b>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void underline() throws RecognitionException, TokenStreamException {
        try {
            this.match(15);
            this.append("<u>");
            int _cnt46 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 14: {
                        this.deleted();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt46 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt46;
            }
            this.match(15);
            this.append("</u>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void italic() throws RecognitionException, TokenStreamException {
        try {
            this.match(8);
            this.append("<i>");
            int _cnt49 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 15: {
                        this.underline();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 14: {
                        this.deleted();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt49 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt49;
            }
            this.match(8);
            this.append("</i>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void monospace() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        try {
            this.match(9);
            this.append("<tt>");
            int _cnt52 = 0;
            block19: while (true) {
                switch (this.LA(1)) {
                    case 4: {
                        this.word();
                        break;
                    }
                    case 5: {
                        this.punctuation();
                        break;
                    }
                    case 24: {
                        this.space();
                        break;
                    }
                    case 7: {
                        st = this.LT(1);
                        this.match(7);
                        this.append(st.getText());
                        break;
                    }
                    case 8: {
                        sl = this.LT(1);
                        this.match(8);
                        this.append(sl.getText());
                        break;
                    }
                    case 10: {
                        h = this.LT(1);
                        this.match(10);
                        this.append(h.getText());
                        break;
                    }
                    case 11: {
                        p = this.LT(1);
                        this.match(11);
                        this.append(p.getText());
                        break;
                    }
                    case 12: {
                        eq = this.LT(1);
                        this.match(12);
                        this.append(eq.getText());
                        break;
                    }
                    case 13: {
                        hh = this.LT(1);
                        this.match(13);
                        this.append(hh.getText());
                        break;
                    }
                    case 6: {
                        e = this.LT(1);
                        this.match(6);
                        this.append(e.getText());
                        break;
                    }
                    case 14: {
                        t = this.LT(1);
                        this.match(14);
                        this.append(t.getText());
                        break;
                    }
                    case 15: {
                        u = this.LT(1);
                        this.match(15);
                        this.append(u.getText());
                        break;
                    }
                    case 16: 
                    case 17: {
                        this.moreSpecialChars();
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        this.htmlSpecialChars();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt52 >= 1) break block19;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt52;
            }
            this.match(9);
            this.append("</tt>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void superscript() throws RecognitionException, TokenStreamException {
        try {
            this.match(10);
            this.append("<sup>");
            int _cnt55 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 15: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 14: {
                        this.deleted();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt55 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt55;
            }
            this.match(10);
            this.append("</sup>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void deleted() throws RecognitionException, TokenStreamException {
        try {
            this.match(14);
            this.append("<del>");
            int _cnt58 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 15: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 25: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt58 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt58;
            }
            this.match(14);
            this.append("</del>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token w = null;
        try {
            w = this.LT(1);
            this.match(4);
            this.append(w.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        try {
            p = this.LT(1);
            this.match(5);
            this.append(p.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void escape() throws RecognitionException, TokenStreamException {
        try {
            this.match(6);
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.specialChars();
                    break;
                }
                case 16: 
                case 17: {
                    this.moreSpecialChars();
                    break;
                }
                case 18: {
                    this.evenMoreSpecialChars();
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.htmlSpecialChars();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        try {
            s = this.LT(1);
            this.match(24);
            this.append(s.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void link() throws RecognitionException, TokenStreamException {
        try {
            this.match(16);
            this.beginCapture();
            while (_tokenSet_10.member(this.LA(1))) {
                this.plain();
            }
            String text = this.endCapture();
            this.match(12);
            this.match(19);
            this.beginCapture();
            this.attributeValue();
            String link = this.endCapture();
            this.append(this.linkTag(text, link));
            this.match(17);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void macro() throws RecognitionException, TokenStreamException {
        try {
            this.match(16);
            this.match(20);
            this.match(12);
            this.beginCapture();
            this.attributeValue();
            String macroName = this.endCapture();
            this.append(this.macroInclude(macroName));
            this.match(17);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token b = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        try {
            switch (this.LA(1)) {
                case 7: {
                    st = this.LT(1);
                    this.match(7);
                    this.append(st.getText());
                    break;
                }
                case 8: {
                    sl = this.LT(1);
                    this.match(8);
                    this.append(sl.getText());
                    break;
                }
                case 9: {
                    b = this.LT(1);
                    this.match(9);
                    this.append(b.getText());
                    break;
                }
                case 10: {
                    h = this.LT(1);
                    this.match(10);
                    this.append(h.getText());
                    break;
                }
                case 11: {
                    p = this.LT(1);
                    this.match(11);
                    this.append(p.getText());
                    break;
                }
                case 12: {
                    eq = this.LT(1);
                    this.match(12);
                    this.append(eq.getText());
                    break;
                }
                case 13: {
                    hh = this.LT(1);
                    this.match(13);
                    this.append(hh.getText());
                    break;
                }
                case 6: {
                    e = this.LT(1);
                    this.match(6);
                    this.append(e.getText());
                    break;
                }
                case 14: {
                    t = this.LT(1);
                    this.match(14);
                    this.append(t.getText());
                    break;
                }
                case 15: {
                    u = this.LT(1);
                    this.match(15);
                    this.append(u.getText());
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
        Token o = null;
        Token c = null;
        try {
            switch (this.LA(1)) {
                case 16: {
                    o = this.LT(1);
                    this.match(16);
                    this.append(o.getText());
                    break;
                }
                case 17: {
                    c = this.LT(1);
                    this.match(17);
                    this.append(c.getText());
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
        Token q = null;
        try {
            q = this.LT(1);
            this.match(18);
            this.append(q.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 19: {
                    this.match(19);
                    this.append("&gt;");
                    break;
                }
                case 20: {
                    this.match(20);
                    this.append("&lt;");
                    break;
                }
                case 21: {
                    this.match(21);
                    this.append("&quot;");
                    break;
                }
                case 22: {
                    this.match(22);
                    this.append("&amp;");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        try {
            block9: while (true) {
                switch (this.LA(1)) {
                    case 22: {
                        this.match(22);
                        this.append("&amp;");
                        continue block9;
                    }
                    case 4: {
                        this.word();
                        continue block9;
                    }
                    case 5: {
                        this.punctuation();
                        continue block9;
                    }
                    case 24: {
                        this.space();
                        continue block9;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.specialChars();
                        continue block9;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
    }

    public final void h1() throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.append("<h1>");
            this.line();
            this.append("</h1>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void h2() throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.match(11);
            this.append("<h2>");
            this.line();
            this.append("</h2>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void h3() throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.match(11);
            this.match(11);
            this.append("<h3>");
            this.line();
            this.append("</h3>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void h4() throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.match(11);
            this.match(11);
            this.match(11);
            this.append("<h4>");
            this.line();
            this.append("</h4>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void olist() throws RecognitionException, TokenStreamException {
        try {
            this.append("<ol>\n");
            int _cnt75 = 0;
            while (true) {
                if (this.LA(1) != 13) {
                    if (_cnt75 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.olistLine();
                this.newlineOrEof();
                ++_cnt75;
            }
            this.append("</ol>\n");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void ulist() throws RecognitionException, TokenStreamException {
        try {
            this.append("<ul>\n");
            int _cnt79 = 0;
            while (true) {
                if (this.LA(1) != 12) {
                    if (_cnt79 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.ulistLine();
                this.newlineOrEof();
                ++_cnt79;
            }
            this.append("</ul>\n");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void olistLine() throws RecognitionException, TokenStreamException {
        try {
            this.match(13);
            this.append("<li>");
            this.line();
            this.append("</li>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void ulistLine() throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.append("<li>");
            this.line();
            this.append("</li>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(20);
            name = this.LT(1);
            this.match(4);
            this.validateElement(name);
            this.append("<");
            this.append(name.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_12);
        }
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        try {
            att = this.LT(1);
            this.match(4);
            while (this.LA(1) == 24) {
                this.space();
            }
            this.match(12);
            while (this.LA(1) == 24) {
                this.space();
            }
            this.match(21);
            this.validateAttribute(att);
            this.append(att.getText());
            this.append("=\"");
            this.attributeValue();
            this.match(21);
            this.append("\"");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_12);
        }
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(19);
            this.append(">");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
    }

    public final void body() throws RecognitionException, TokenStreamException {
        try {
            block10: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 24: {
                        this.plain();
                        continue block10;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: {
                        this.formatted();
                        continue block10;
                    }
                    case 23: {
                        this.preformatted();
                        continue block10;
                    }
                    case 21: {
                        this.quoted();
                        continue block10;
                    }
                    case 12: 
                    case 13: {
                        this.list();
                        this.newline();
                        continue block10;
                    }
                    case 25: {
                        this.newline();
                        continue block10;
                    }
                }
                if (this.LA(1) == 20 && this.LA(2) == 4) {
                    this.html();
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_13);
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(20);
            this.match(8);
            name = this.LT(1);
            this.match(4);
            this.match(19);
            this.append("</");
            this.append(name.getText());
            this.append(">");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(8);
            this.match(19);
            this.append("/>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{66846706L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{16893936L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{61994992L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{28440560L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{2050L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{61997042L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{61994994L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{0x2000002L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{0x1011070L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{0x1010070L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{0x220000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{0x1080100L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{0x100000L, 0L};
        return data;
    }
}

