/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.Selector;
import org.jboss.seam.international.Locale;
import org.jboss.seam.international.Messages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.theme.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.theme.themeSelector")
@BypassInterceptors
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
public class ThemeSelector
extends Selector {
    private static final long serialVersionUID = 3920407140011388341L;
    private static final LogProvider log = Logging.getLogProvider(ThemeSelector.class);
    private String theme;
    private String[] availableThemes;

    @Create
    public void initDefaultTheme() {
        String themeName = this.getCookieValueIfEnabled();
        if (themeName != null && Arrays.asList(this.availableThemes).contains(themeName)) {
            this.setTheme(themeName);
        }
        if (this.theme == null) {
            if (this.availableThemes == null || this.availableThemes.length == 0) {
                throw new IllegalStateException("no themes defined");
            }
            this.theme = this.availableThemes[0];
        }
    }

    @Override
    protected String getCookieName() {
        return "org.jboss.seam.core.Theme";
    }

    public void select() {
        Contexts.removeFromAllContexts(Seam.getComponentName(Theme.class));
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = Pages.getViewId(facesContext);
        UIViewRoot viewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, viewId);
        facesContext.setViewRoot(viewRoot);
        this.setCookieValueIfEnabled(this.getTheme());
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.themeSelected", this.getTheme());
        }
    }

    public void select(ValueChangeEvent event) {
        this.selectTheme((String)event.getNewValue());
    }

    public void selectTheme(String themeName) {
        this.setTheme(themeName);
        this.select();
    }

    public List<SelectItem> getThemes() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(this.availableThemes.length);
        for (String name : this.availableThemes) {
            selectItems.add(new SelectItem((Object)name, this.getLocalizedThemeName(name)));
        }
        return selectItems;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String themeName) {
        this.setDirty(this.theme, themeName);
        this.theme = themeName;
    }

    public void setAvailableThemes(String[] themeNames) {
        this.setDirty(this.availableThemes, themeNames);
        this.availableThemes = themeNames;
    }

    public ResourceBundle getThemeResourceBundle() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.theme, Locale.instance(), Thread.currentThread().getContextClassLoader());
            log.debug("loaded resource bundle: " + this.theme);
            return bundle;
        }
        catch (MissingResourceException mre) {
            log.debug("resource bundle missing: " + this.theme);
            return null;
        }
    }

    public String getLocalizedThemeName(String name) {
        String localizedName;
        String key = "org.jboss.seam.theme." + name;
        return key.equals(localizedName = Messages.instance().get(key)) ? name : localizedName;
    }

    public static ThemeSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (ThemeSelector)Component.getInstance(ThemeSelector.class, ScopeType.SESSION);
    }

    public String[] getAvailableThemes() {
        return this.availableThemes;
    }
}

