/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.ejb.EJBContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.Transaction;

public class CMTTransaction
extends AbstractUserTransaction {
    private final EJBContext ejbContext;
    private final Transaction parent;

    public CMTTransaction(EJBContext ejbContext, Transaction parent) {
        this.parent = parent;
        this.ejbContext = ejbContext;
        if (ejbContext == null) {
            throw new IllegalArgumentException("null EJBContext");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.ejbContext.getUserTransaction().begin();
        this.parent.afterBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        UserTransaction userTransaction = this.ejbContext.getUserTransaction();
        boolean success = false;
        this.parent.beforeCommit();
        try {
            userTransaction.commit();
            success = true;
        }
        finally {
            this.parent.afterCommit(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        UserTransaction userTransaction = this.ejbContext.getUserTransaction();
        try {
            userTransaction.rollback();
        }
        finally {
            this.parent.afterRollback();
        }
    }

    public int getStatus() throws SystemException {
        try {
            if (!this.ejbContext.getRollbackOnly()) {
                return 0;
            }
            return 1;
        }
        catch (IllegalStateException ise) {
            return this.ejbContext.getUserTransaction().getStatus();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.ejbContext.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.ejbContext.getUserTransaction().setTransactionTimeout(timeout);
    }

    public void registerSynchronization(Synchronization sync) {
        if (!this.parent.isAwareOfContainerTransactions()) {
            throw new UnsupportedOperationException("cannot register synchronization with container transaction, use <transaction:ejb-transaction/>");
        }
        this.parent.registerSynchronization(sync);
    }
}

