/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.util.Stack;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.transaction.CMTTransaction;
import org.jboss.seam.transaction.NoTransaction;
import org.jboss.seam.transaction.SynchronizationRegistry;
import org.jboss.seam.transaction.UTTransaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Naming;

@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(precedence=0)
@BypassInterceptors
public class Transaction {
    private static final String STANDARD_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static String userTransactionName = "UserTransaction";
    protected Stack<SynchronizationRegistry> synchronizations = new Stack();

    public void afterBegin() {
        this.synchronizations.push(new SynchronizationRegistry());
    }

    protected void afterCommit(boolean success) {
        this.synchronizations.pop().afterTransactionCompletion(success);
    }

    protected void afterRollback() {
        this.synchronizations.pop().afterTransactionCompletion(false);
    }

    protected void beforeCommit() {
        this.synchronizations.peek().beforeTransactionCompletion();
    }

    protected void registerSynchronization(Synchronization sync) {
        if (this.synchronizations == null) {
            throw new IllegalStateException("no transaction active, or the transaction is a CMT (try installing <transaction:ejb-transaction/>)");
        }
        this.synchronizations.peek().registerSynchronization(sync);
    }

    protected boolean isAwareOfContainerTransactions() {
        return false;
    }

    public static void setUserTransactionName(String name) {
        userTransactionName = name;
    }

    public static String getUserTransactionName() {
        return userTransactionName;
    }

    public static UserTransaction instance() {
        return (UserTransaction)Component.getInstance(Transaction.class, ScopeType.EVENT);
    }

    @Unwrap
    public UserTransaction getTransaction() throws NamingException {
        try {
            return this.createUTTransaction();
        }
        catch (NameNotFoundException nnfe) {
            try {
                return this.createEJBTransaction();
            }
            catch (NameNotFoundException nnfe2) {
                return this.createNoTransaction();
            }
        }
    }

    protected UserTransaction createNoTransaction() {
        return new NoTransaction();
    }

    protected UserTransaction createEJBTransaction() throws NamingException {
        return new CMTTransaction(EJB.getEJBContext(), this);
    }

    protected UserTransaction createUTTransaction() throws NamingException {
        return new UTTransaction(this.getUserTransaction(), this);
    }

    protected javax.transaction.UserTransaction getUserTransaction() throws NamingException {
        try {
            return (javax.transaction.UserTransaction)Naming.getInitialContext().lookup(userTransactionName);
        }
        catch (NameNotFoundException nnfe) {
            return (javax.transaction.UserTransaction)Naming.getInitialContext().lookup(STANDARD_USER_TRANSACTION_NAME);
        }
    }
}

