/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.Transaction;

public class UTTransaction
extends AbstractUserTransaction {
    private final UserTransaction delegate;
    private final Transaction parent;

    UTTransaction(UserTransaction delegate, Transaction parent) {
        this.parent = parent;
        this.delegate = delegate;
        if (delegate == null) {
            throw new IllegalArgumentException("null UserTransaction");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        this.parent.afterBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        boolean success = false;
        this.parent.beforeCommit();
        try {
            this.delegate.commit();
            success = true;
        }
        finally {
            this.parent.afterCommit(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.delegate.rollback();
        }
        finally {
            this.parent.afterRollback();
        }
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.delegate.setTransactionTimeout(timeout);
    }

    public void registerSynchronization(Synchronization sync) {
        this.parent.registerSynchronization(sync);
    }
}

