/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.web.AbstractFilter;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.exceptionFilter")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.ajax4jsfFilter"})
public class ExceptionFilter
extends AbstractFilter {
    private static final LogProvider log = Logging.getLogProvider(ExceptionFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            log.error("handling uncaught exception", e);
            log.error("exception root cause", EJB.getCause(e));
            this.endWebRequestAfterException((HttpServletRequest)request, (HttpServletResponse)response, e);
        }
    }

    protected void endWebRequestAfterException(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        log.debug("ending request");
        MockFacesContext facesContext = this.createFacesContext(request, response);
        facesContext.setCurrent();
        FacesLifecycle.beginExceptionRecovery(facesContext.getExternalContext());
        Manager.instance().initializeTemporaryConversation();
        try {
            this.rollbackTransactionIfNecessary();
            Exceptions.instance().handle(e);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ehe) {
            throw new ServletException((Throwable)ehe);
        }
        finally {
            try {
                FacesLifecycle.endRequest(facesContext.getExternalContext());
                facesContext.release();
                log.debug("ended request");
            }
            catch (Exception ere) {
                log.error("could not destroy contexts", e);
            }
        }
    }

    private MockFacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        MockFacesContext mockFacesContext = new MockFacesContext(new MockExternalContext(this.getServletContext(), request, response), new MockApplication());
        mockFacesContext.setViewRoot(new UIViewRoot());
        return mockFacesContext;
    }

    protected void rollbackTransactionIfNecessary() {
        try {
            UserTransaction transaction = Transaction.instance();
            if (transaction.isActiveOrMarkedRollback() || transaction.isRolledBack()) {
                log.debug("killing transaction");
                transaction.rollback();
            }
        }
        catch (Exception te) {
            log.error("could not roll back transaction", te);
        }
    }
}

