/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.web.AbstractFilter;
import org.jboss.seam.web.MultipartRequest;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.multipartFilter")
@Install(precedence=0)
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.ajax4jsfFilter", "org.jboss.seam.web.exceptionFilter"})
public class MultipartFilter
extends AbstractFilter {
    public static final String MULTIPART = "multipart/";
    private boolean createTempFiles = false;
    private int maxRequestSize = 0;

    public boolean getCreateTempFiles() {
        return this.createTempFiles;
    }

    public void setCreateTempFiles(boolean createTempFiles) {
        this.createTempFiles = createTempFiles;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxFileSize) {
        this.maxRequestSize = maxFileSize;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isMultipartRequest(httpRequest)) {
            chain.doFilter((ServletRequest)new MultipartRequest(httpRequest, this.createTempFiles, this.maxRequestSize), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }
}

