﻿using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command
{
    class AddCommandArgs:CommandArg
    {
        private TaskData _data;
        private int _categoryID;

        public TaskData PreparedTaskData
        {
            get { return _data; }
        }
        public int CategoryID
        {
            get { return _categoryID; }
        }

        public void split(string arguments)
        {
            _data = new TaskData();
            string[] spaceSplitData = arguments.Split(' ');
            string command = spaceSplitData[0].ToLower();
            foreach (string options in spaceSplitData)
            {
                if (string.Equals(command,options.ToLower())) { continue; }
                string[] optionData = options.Split(':');
                switch (optionData[0].ToUpper())
                {
                    case "@":
                        //時間帯
                        if (optionData[1].Length == 1)
                        {
                            _data.TimeArea = optionData[1];
                        }
                        break;
                    case "D":
                        //日付
                        if (optionData[1].Length == 4 || optionData[1].Length == 8)
                        {
                            _data.DoDate = new DateComponent(optionData[1]);
                        }
                        break;
                    case "C":
                        //カテゴリ
                        CategoryDataAccessor dataAccessor = CategoryDataAccessor.getObject;
                        CategoryData categData = dataAccessor.getCategoryFromName(optionData[1]);
                        if (categData != null)
                        {
                            _data.Category = optionData[1];
                            _categoryID = categData.CategId;
                        }
                        break;
                    case "F":
                        decimal forcastTime;
                        string timestr;
                        if (optionData[1].ToLower().EndsWith("h"))
                        {
                            timestr = optionData[1].Substring(0, optionData[1].Length - 1);
                            if (decimal.TryParse(timestr, out forcastTime))
                            {
                                _data.ForecastMin = decimal.ToInt32(forcastTime *  60);
                            }
                        }
                        else if (decimal.TryParse(optionData[1], out forcastTime))
                        {
                            _data.ForecastMin = decimal.ToInt32(forcastTime);
                        }

                        break;
                    case "N":
                        int outInt;

                        if (int.TryParse(optionData[1], out outInt))
                        {
                            _data.SortID = outInt;
                        }
                        else
                        {
                            _data.SortID = 0;
                        }
                        break;
                    default:
                        //なにもない場合はコンテンツ(最初の記載を是とする)
                        if (_data.Contents == null || _data.Contents == string.Empty)
                        {
                            _data.Contents = optionData[0];
                            //コロンを含む場合もあるので一応確認
                            for (int i = 1; i < optionData.Length; i++)
                            {
                                _data.Contents += ":" + optionData[i];
                            }
                        }
                        break;
                }
            }
        }

        public bool getSplitResult()
        {
            return true;
        }
    }
}
