﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.DAO;
using System.Windows.Forms;

namespace com.andoutomo.kybernetes.command.Control
{
    class CheckCommand:AbCommand
    {
        CheckCommandArg param;
        protected override bool execute()
        {
            TaskDataAccessor accessor = TaskDataAccessor.getObject;

            param = (CheckCommandArg)argument;
            TaskData target = accessor.getTask(param.sortID);
            if (param.AutoMode)
            {

                if (target != null)
                {
                    TimeComponent lastEndtime = accessor.getNextStartTime(target.DoDate);
                    if (lastEndtime != null && lastEndtime.IsValid)
                    {
                        if (accessor.startTask(target.SortID, lastEndtime))
                        {
                            if (accessor.endTask(target.SortID, lastEndtime))
                            {
                                string endingComment = form.showInputBox("本タスクへのコメントをどうぞ。", ImeMode.Hiragana);
                                if (!string.IsNullOrEmpty(endingComment))
                                {
                                    CommentData data = new CommentData();
                                    data.TaskID = target.TaskID;
                                    data.Comment = endingComment;

                                    CommentDataAccessor.getObject.insertComment(data);
                                }
                                return repeatCheck(target);
                            }
                            else
                            {
                                return true;
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                    else
                    {
                        message = "終了しているタスクが無いため、自動設定できません。最初は時刻を手動設定してください。";
                        return false;
                    }
                }
                else
                {
                    base.errorType = ErrorType.DataNotFound;
                    return false;
                }
            }
            else
            {
                if (accessor.startTask(param.sortID, param.reportTime))
                {
                    if (accessor.endTask(param.sortID, param.reportTime))
                    {
                        string endingComment = form.showInputBox("本タスクへのコメントをどうぞ。", ImeMode.Hiragana);
                        if (!string.IsNullOrEmpty(endingComment))
                        {
                            CommentData data = new CommentData();
                            data.TaskID = target.TaskID;
                            data.Comment = endingComment;

                            CommentDataAccessor.getObject.insertComment(data);
                        }
                        return repeatCheck(target);
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }
        }
        string message;

        protected override string turnMessage()
        {
            return "タスク " + param.sortID + " をチェック完了しました。";
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultErrorMessage;
            }
            return message;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="_newData"></param>
        /// <returns></returns>
        private bool repeatCheck(TaskData _newData)
        {
            if (TaskDataAccessor.getObject.isRepeatTask(param.sortID))
            {
                string nextDay = form.showInputBox("次回は何日後ですか？0の場合は繰り返しません。", "1");
                if (nextDay != "0")
                {
                    _newData.DoDate.addDate(int.Parse(nextDay));
                    _newData.TaskID = TaskDataAccessor.getObject.getMaxTaskID();
                    _newData.SortID = TaskDataAccessor.getObject.getMaxSortID();


                    //_newData.CategID = CategoryDataAccessor.getObject.getCategoryFromName(_newData.Category).CategId;

                    TaskDataAccessor.getObject.insertTask(_newData);

                    //リピート対象としたタスクは複製後もリピート対象とする。
                    TaskDataAccessor.getObject.setRepeatTask(_newData.SortID, true);

                    message = "タスク " + param.sortID + " を終了します。次回は" + _newData.DoDate.getDateString() + "です。";
                    return true;
                }
                else
                {
                    //リピートしないと判断したならそこで終了。
                    return true;
                }
            }
            else
            {
                //リピート対象でないなら何もしない
                return true;
            }
        }
        
    }
}
