﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.view;

namespace com.andoutomo.kybernetes.command.Control
{
    class CommentCommand:AbCommand
    {
        private string message;
        protected override bool execute()
        {
            CommentCommandArg param = (CommentCommandArg)argument;
            CommentDataAccessor dataAccessor = CommentDataAccessor.getObject;
            bool retVal = false;
            
            switch (param.mode)
            {
                case CommentMode.show:
                    List<CommentData> dataList = dataAccessor.getComment();
                    List<string> dataForConsole = new List<string>();
                    foreach (CommentData data in dataList)
                    {
                        dataForConsole.Add("------ " + data.CreateDateStr + " ------");
                        if (data.TaskID != 0)
                        {
                            int sortID = TaskDataAccessor.getObject.getSortIDFromTaskID(data.TaskID);
                            if (sortID > 0)
                            {
                                dataForConsole.Add("-- For TaskNo." + sortID + " --");
                            }
                        }
                        dataForConsole.Add(data.Comment);
                    }
                    form.addMultiText(dataForConsole);
                    
                    retVal = true;
                    message = string.Empty;

                    break;

                case CommentMode.metaComment:
                    //コメントが数字の場合は、間違いかもしれないから一応聞く
                    int wkSortID;
                    if (int.TryParse(param.Comment, out wkSortID))
                    {
                        if (!YesNoDialog.show(param.Comment + "をコメントとして入力しますか？"))
                        {
                            message = "処理を中断しました。";
                            retVal = true;
                            break;
                        }
                    }

                    retVal = dataAccessor.insertMetaComment(param.Comment);

                    message = "全体コメントを追加しました。";
                    break;

                case CommentMode.taskComment:
                    TaskData taskData =TaskDataAccessor.getObject.getTask(param.sortID);
                    if (null != taskData)
                    {
                        CommentData data = new CommentData();
                        data.TaskID = taskData.TaskID;
                        data.Comment = param.Comment;

                        retVal = dataAccessor.insertComment(data);
                        message = "タスクNo." + taskData.SortID + " にコメントを追加しました。";
                    }
                        //タスクが実在しない場合
                    else
                    {
                        base.errorType = ErrorType.DataNotFound;
                        retVal=false;
                    }
                    break;
                default:
                    break;
            }
            return retVal;
        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
