﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.andoutomo.kybernetes.command.Control
{
    class CommentCommandArg:CommandArg
    {
        public CommentMode mode
        {
            get;
            private set;
        }

        public int sortID
        {
            get;
            private set;
        }
        public string Comment
        {
            get;
            private set;
        }

        public void split(string arguments)
        {
            string[] splitData = arguments.Split(' ');
            if (splitData.Length < 2)
            {
                mode = CommentMode.show;
            }
            else if (splitData.Length == 2)
            {
                mode = CommentMode.metaComment;
                Comment = splitData[1];
            }
            else
            {
                int wkSortID;
                if (int.TryParse(splitData[1], out wkSortID))
                {
                    sortID = wkSortID;
                    mode = CommentMode.taskComment;
                    for (int i = 2; i < splitData.Length; i++)
                    {
                        Comment += splitData[i] + " ";
                    }
                }
                else
                {
                    mode = CommentMode.metaComment;
                    for (int i = 1; i < splitData.Length; i++)
                    {
                        Comment += splitData[i] + " ";
                    }
                }
            }
        }

        public bool getSplitResult()
        {
            return true;
        }
    }
    public enum CommentMode
    {
        show,
        metaComment,
        taskComment
    }
}
