﻿using System;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class DelayCommand:AbCommand
    {
        int taskID;
        DateComponent retDate;

        protected override bool execute()
        {
            DelayCommandArg param = (DelayCommandArg)argument;
            taskID = param.sortID;

            if (param.nextDate == null)
            {
                TaskData data = TaskDataAccessor.getObject.getTask(param.sortID);
                if (data == null)
                {
                    base.errorType = ErrorType.DataNotFound;
                    return false;
                }
                retDate = data.DoDate;

                if (param.DateToSkip != int.MinValue)
                {
                    retDate.addDate(param.DateToSkip);
                }
                else
                {
                    string dateStr = form.showInputBox("何日先に延ばしますか？");
                    if (string.IsNullOrEmpty(dateStr))
                    {
                        dateStr = "0";
                    }
                    retDate.addDate(Convert.ToInt32(dateStr));
                }
            }
            else
            {
                retDate = param.nextDate;
            }


            return TaskDataAccessor.getObject.delayTask(param.sortID, retDate);
        }

        protected override string turnMessage()
        {
            return "タスク" + taskID + "を" + retDate.getDateString() +"に延期しました。";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
