﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class DuplicateCommand:AbCommand
    {
        string message;
        protected override bool execute()
        {
            DuplicateCommandArg param = (DuplicateCommandArg)argument;

            TaskDataAccessor accessor = TaskDataAccessor.getObject;
            // データを取得
            TaskData data = accessor.getTask(param.sortID);
            if (data == null)
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            // 次番号を取得
            data.TaskID = accessor.getMaxTaskID();
            data.SortID = accessor.getMaxSortID();
            //見積もり時間は0にする。
            data.ForecastMin = 0;


            //データをインサート
            if (accessor.insertTask(data))
            {
                message = "タスク「" + data.Contents + "」を番号" + data.SortID + "で複製しました。";
                return true;
            }
            else
            {
                return false;
            }


        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
