﻿using com.andoutomo.kybernetes.data.accessor;

namespace com.andoutomo.kybernetes.command
{
    class RepeatCommand:AbCommand
    {
        RepeatCommandArg param;
        protected override bool execute()
        {
            param = (RepeatCommandArg)argument;

            if (!param.dataExists())
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            return TaskDataAccessor.getObject.setRepeatTask(param.sortID, param.isRepeat);
        }

        
        protected override string turnMessage()
        {
            if (param.isRepeat)
            {
                return "タスク " + param.sortID + " をリピート対象としました。";
            }
            else
            {
                return "タスク " + param.sortID + " をリピート対象から外しました。";
            }
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
