﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.reference
{
    class FindCommand:AbCommand
    {
        protected override bool execute()
        {
            FindCommandArg param = (FindCommandArg)argument;

            DateComponent todayDate = SettingDataAccessor.getObject.getToday();
            List<TaskData> dataList = TaskDataAccessor.getObject.findTask(param.searchWord);


            if (dataList.Count <= 0)
            {
                message = "見つかりませんでした。";
            }
            else
            {
                message = dataList.Count + "件のタスクが見つかりました。";
            }

            form.clearPanel();
            string wkAreaForIndex = "";
            foreach (TaskData data in dataList)
            {
                data.Today = todayDate;
                if (!data.isComplete)
                {
                    if (wkAreaForIndex != data.TimeArea)
                    {
                        string wkIndex = "- " + data.TimeArea + " - on " + data.DoDate.getDateString("yyyy/MM/dd");
                        form.addIndexPanel(wkIndex);
                    }

                    wkAreaForIndex = data.TimeArea;
                }
                form.addPanel(data);
            }

            return true;
        }

        private string message;
        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
