﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.SYSTEM
{
    class LinkCommand:AbCommand
    {
        LinkCommandArg param;
        string errMessage;

        protected override bool execute()
        {
            param = (LinkCommandArg)argument;
            LinkDataAccessor accessor = LinkDataAccessor.getObject;
            bool hasLink =accessor.hasLink(param.ShortcutStr);
            bool retVal=false;

            //リストモード(一覧取得)
            if (param.listMode)
            {
                List<SimpleDataBean> linklist = accessor.getAllLink();
                List<string> retList = new List<string>();
                foreach (SimpleDataBean data in linklist)
                {
                    retList.Add(data.Name + " -> " + data.Val);
                }
                form.addMultiText(retList);
                retStr = string.Empty;
                return true;
            }


            if (param.removeMode)
                //削除
            {
                if (hasLink)
                {
                    //削除対象があれば削除
                    retVal = accessor.removeLink(param.ShortcutStr);
                }
                else
                {
                    //ない場合はエラー
                    errMessage = "リンク " + param.ShortcutStr + " は存在しないため、削除できません。";
                    retVal = false;
                }
            }
            else
                //追加
            {
                if (hasLink)
                {
                    //追加対象が既にあればエラー
                    errMessage = "リンク " + param.ShortcutStr + " は既に存在するため、作成できません。";
                    retVal = false;
                }
                else
                {
                    //ない場合に作成する
                    retVal = accessor.addLink(param.ShortcutStr, param.BaseCommandStr);

                }
            }
            retStr = param.ShortcutStr + "->" + param.BaseCommandStr;
            return retVal;
        }
        string retStr;
        protected override string turnMessage()
        {
            return retStr;
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(errMessage))
            {
                return base.DefaultErrorMessage;
            }
            else
            {
                return errMessage;
            }
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
