﻿using com.andoutomo.kybernetes.control;

namespace com.andoutomo.kybernetes.command.SYSTEM
{
    class LogModeCommandArg:CommandArg
    {
        public bool showMode
        {
            get;
            private set;
        }
        public LogMode LogModeToChange
        {
            get;
            private set;
        }

        public void split(string arguments)
        {
            string[] splitData = arguments.Split(' ');
            if (splitData.Length == 1)
            {
                showMode = true;
                isValid = true;
            }
            else
            {
                showMode = false;
                if (string.Equals(splitData[1].ToLower(), "debug"))
                {
                    LogModeToChange = LogMode.Debug;
                    isValid = true;
                }
                else if (string.Equals(splitData[1].ToLower(), "trace"))
                {
                    LogModeToChange = LogMode.Trace;
                    isValid = true;
                }
                else if (string.Equals(splitData[1].ToLower(), "error"))
                {
                    LogModeToChange = LogMode.Error;
                    isValid = true;
                }
                else
                {
                    isValid = false;
                }
            }
        }
        private bool isValid;
        public bool getSplitResult()
        {
            return isValid;
        }
    }
}
