﻿using System;
using System.Text;
using System.IO;

namespace com.andoutomo.kybernetes.control
{


    public enum LogMode
    {
        Error,
        Trace,
        Debug

    }
    public class KybernetesLogger
    {
        string logpath;
        StreamWriter writer;


        public static LogMode CurrentLogMode
        {
            private get;
            set;
        }

        static KybernetesLogger innerObject;

        private KybernetesLogger()
        {
            logpath = System.AppDomain.CurrentDomain.BaseDirectory + "kybernetes.log";
        }
        /// <summary>
        /// ログ出力オブジェクト
        /// </summary>
        public static KybernetesLogger Log
        {
            get
            {
                if (innerObject == null)
                {
                    innerObject = new KybernetesLogger();
                }
                return innerObject;
            }
        }
        /// <summary>
        /// ログレベル・エラー(常時出力)
        /// </summary>
        /// <param name="logContents"></param>
        public void error(string logContents)
        {
            switch (CurrentLogMode)
            {
                case LogMode.Error:
                case LogMode.Trace:
                case LogMode.Debug:
                    sendLog(logContents);
                    break;
                default:
                    break;
            }
        }
        /// <summary>
        /// ログレベル・トレース(通常時は出力しない)
        /// </summary>
        /// <param name="logContents"></param>
        public void trace(string logContents)
        {
            switch (CurrentLogMode)
            {
                case LogMode.Error:
                    break;
                case LogMode.Trace:
                case LogMode.Debug:
                    sendLog(logContents);
                    break;
                default:
                    break;
            }
        }
        /// <summary>
        /// ログレベル・デバッグ(通常/トレース時は出力しない)
        /// </summary>
        /// <param name="logContents"></param>
        public void debug(string logContents)
        {
            switch (CurrentLogMode)
            {
                case LogMode.Error:
                case LogMode.Trace:
                    break;
                case LogMode.Debug:
                    sendLog(logContents);
                    break;
                default:
                    break;
            }
        }


        private void sendLog(string logContents)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss.fff")).Append("---");
            builder.Append(logContents);

            try
            {
                writer = new StreamWriter(logpath, true, System.Text.Encoding.GetEncoding("shift_jis"));
                writer.WriteLine(builder.ToString());
            }
            catch (Exception e)
            {
                //ここでは何もしない
            }
            finally
            {
                if (writer != null)
                {
                    writer.Close();
                }

            }
        }

    }
}
