﻿using System;
using com.andoutomo.kybernetes.control;

namespace com.andoutomo.kybernetes.data
{
    public class DateComponent
    {
        private DateTime innerDate;

        public DateComponent(int year, int month, int day)
        {
            innerDate = new DateTime(year, month, day);
        }
        public DateComponent(int month, int day)
        {
            innerDate = new DateTime(DateTime.Today.Year, month, day);
        }
        /// <summary>
        /// スペース区切りで日付と時刻を分け、日付のみさらにスプリッタで分ける。
        /// SQLite向けコンストラクタ
        /// </summary>
        /// <param name="dateStr"></param>
        /// <param name="separater"></param>
        public DateComponent(string dateStr, char separater)
        {
            string[] wkData1 = dateStr.Split(' ');
            string[] wkData2 = wkData1[0].Split(separater);
            innerDate = new DateTime(int.Parse(wkData2[0]), int.Parse(wkData2[1]), int.Parse(wkData2[2]));
        }
        /// <summary>
        /// yyyyMMdd方式か、MMdd方式で表記された文字列から日付コンポーネントを作成する
        /// </summary>
        /// <param name="dateStr"></param>
        public DateComponent(string dateStr)
        {
            try
            {
                if (dateStr.Length == 8)
                {
                    string yearStr = dateStr.Substring(0, 4);
                    string monthStr = dateStr.Substring(4, 2);
                    string dayStr = dateStr.Substring(6, 2);
                    innerDate = new DateTime(int.Parse(yearStr), int.Parse(monthStr), int.Parse(dayStr));
                }
                else if (dateStr.Length == 4)
                {
                    string monthStr = dateStr.Substring(0, 2);
                    string dayStr = dateStr.Substring(2, 2);
                    innerDate = new DateTime(DateTime.Today.Year, int.Parse(monthStr), int.Parse(dayStr));

                }
                else
                {
                    throw new KybernetesApplicationException("日付への変換ができません:" + dateStr);
                }
            }
            catch (Exception e)
            {
                throw new KybernetesApplicationException(e);
            }
        }

        public DateComponent(DateTime dateTime)
        {
            innerDate = dateTime;
        }

        public void addDate(int dateToAdd)
        {
            innerDate = innerDate.AddDays(dateToAdd);
        }

        /// <summary>
        /// 日付文字列を出力(デフォルト)
        /// </summary>
        /// <returns></returns>
        public string getDateString()
        {
            return innerDate.ToString("MM/dd");
        }
        public string getDateString(string format)
        {
            return innerDate.ToString(format);
        }
        /// <summary>
        /// 曜日を出力します。
        /// </summary>
        /// <returns></returns>
        public string getDowStr()
        {
            switch (innerDate.DayOfWeek){
                case DayOfWeek.Monday:
                    return "月";
                case DayOfWeek.Tuesday:
                    return "火";
                case DayOfWeek.Wednesday:
                    return "水";
                case DayOfWeek.Thursday:
                    return "木";
                case DayOfWeek.Friday:
                    return "金";
                case DayOfWeek.Saturday:
                    return "土";
                case DayOfWeek.Sunday:
                    return "日";

                default:
                    return "";
            }
        }
        /// <summary>
        /// 日数差を計算します。
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public int calculateDateDiff(DateComponent target)
        {
            TimeSpan thisDateLange = innerDate.Subtract(target.innerDate);
            return thisDateLange.Days;
        }
    }
}
