﻿using System;

namespace com.andoutomo.kybernetes.data
{
    public class TimeComponent
    {
        private int hour;
        private int minute;


        #region getter/setter
        public int Hour
        {
            get { return hour; }
        }
        public int Minute
        {
            get { return minute; }
        }

        public int TotalMinute
        {
            get { return hour * 60 + minute; }
        }
        public decimal TotalHour
        {
            get { return hour + (minute / 60); }
        }
        #endregion

        #region Constructor & defaultMethod
        private TimeComponent(){}

        public TimeComponent(int _hour, int _minute)
        {
            minuteToTime(_hour * 60 + _minute);
            if (this.hour != -1 && this.minute != -1) { IsValid = true; }
        }

        public TimeComponent(int _totalMinute)
        {
            minuteToTime(_totalMinute);
            if (this.hour != -1 && this.minute != -1) { IsValid = true; }
        }


        public bool IsValid
        {
            get;
            private set;
        }

        public TimeComponent(string _timeStr)
        {
            if (_timeStr == null || _timeStr.Equals(string.Empty))
            {
                IsValid = false;
                this.hour = -1;
                this.minute = -1;
                return;
            }
            IsValid = true;


            string[] data = _timeStr.Split(':');
            if (data.Length >= 2)
            {
                this.minuteToTime(int.Parse(data[0]) * 60 + int.Parse(data[1]));
            }
            else
            {
                this.minuteToTime(int.Parse(data[0]));
            }
        }
        public override int GetHashCode()
        {
            return base.GetHashCode();
        }
        public override string ToString()
        {
            if (IsValid)
            {
                return hour.ToString("00") + ":" + minute.ToString("00");
            }
            return string.Empty;
        }

        public override bool Equals(object obj)
        {
            if (!(obj is TimeComponent))
            {
                return false;
            }
            if (base.Equals(obj))
            {
                return true;
            }

            return this.TotalMinute == ((TimeComponent)obj).TotalMinute;
        }
        #endregion

        #region Calculate
        #region add
        public TimeComponent add(int minute)
        {
            minuteToTime(minute + this.TotalMinute);
            return this;
        }
        public TimeComponent add(int hour, int minute)
        {
            return add(hour * 60 + minute);
            
        }
        public TimeComponent add(TimeComponent time)
        {
            return add(time.TotalMinute);
            
        }
        #endregion

        #region subtract
        public TimeComponent subtract(int _minute)
        {
            minuteToTime(this.TotalMinute - _minute);
            return this;
        }
        public TimeComponent subtract(int _hour, int _minute)
        {
            return subtract(hour * 60 + minute);
            
        }
        public TimeComponent subtract(TimeComponent time)
        {
            return subtract(time.TotalMinute);
        }
        #endregion



        private void minuteToTime(int minute)
        {
            decimal decData = minute;
            if (decData <= 0)
            {
                IsValid = false;
                this.hour = -1;
                this.minute = -1;

            }


            this.hour = decimal.ToInt32(decimal.Divide(decData, 60));
            this.minute = decimal.ToInt32(decimal.Remainder(decData, 60));
        }
        #endregion

        public int getSubtractionMinute(TimeComponent from)
        {
            return decimal.ToInt32(Math.Abs(this.TotalMinute - from.TotalMinute));
        }
        public TimeComponent getSubtractionComponent(TimeComponent from)
        {
            return new TimeComponent(this.getSubtractionMinute(from));
        }

        public static TimeComponent justNow()
        {
            return new TimeComponent(DateTime.Now.Hour, DateTime.Now.Minute);
        }
    }
}
