﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.connection;
using System.Data.SQLite;

namespace com.andoutomo.kybernetes.data.accessor
{
    public class CommentDataAccessor
    {
        #region singleton
        private static CommentDataAccessor accessor;
        private CommentDataAccessor()
        {
        }
        public static CommentDataAccessor getObject
        {
            get
            {
                if (accessor == null)
                {
                    accessor = new CommentDataAccessor();
                }
                return accessor;
            }
        }
        #endregion

        private List<CommentData> getCommentInner(string sql,List<object> paramList)
        {
            List<CommentData> result = new List<CommentData>();
            
            

            TaskDBConnection.Connection.selectData(sql, paramList,
                (SQLiteDataReader reader) =>
                {
                    while (reader.Read())
                    {
                        CommentData data = new CommentData();
                        data.CommentID = Convert.ToInt32(reader["ID"].ToString());
                        if (string.IsNullOrEmpty(reader["TASKID"].ToString()))
                        {
                            data.TaskID = 0; 
                        }
                        else
                        {
                            data.TaskID = Convert.ToInt32(reader["TASKID"].ToString());
                        }
                        
                        data.CreateDate = Convert.ToDateTime(reader["CREATETIME"].ToString());
                        data.Comment = reader["COMMENT"].ToString();

                        result.Add(data);
                    }
                });
            return result;
        }

        /// <summary>
        /// 対象IDに紐づくコメントを抽出する
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public List<CommentData> getComment(int id)
        {
            List<object> paramList = new List<object>() { id };
            return getCommentInner(SqlDictionary.getComments,paramList);
        }
        /// <summary>
        /// メタコメントを抽出する.
        /// システム日付と一致するもののみ抽出する。
        /// </summary>
        /// <returns></returns>
        public List<CommentData> getComment()
        {
            return getCommentInner(SqlDictionary.getMetaComment, new List<object>());
        }

        /// <summary>
        /// コメントを入力する
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public bool insertComment(CommentData data)
        {
            List<object> paramList = new List<object>();
            paramList.Add(data.TaskID);
            paramList.Add(data.Comment);

            return TaskDBConnection.Connection.updateData(SqlDictionary.insertComment, paramList);
        }
        /// <summary>
        /// メタコメントを入力する
        /// </summary>
        /// <param name="comment"></param>
        /// <returns></returns>
        public bool insertMetaComment(string comment)
        {
            List<object> paramList = new List<object>() { comment };
            return TaskDBConnection.Connection.updateData(SqlDictionary.insertMetaComment, paramList);
        }

        /// <summary>
        /// 紐付きを失ったコメントを全削除します。
        /// </summary>
        /// <returns></returns>
        public bool deleteCommentWithTask()
        {
            return TaskDBConnection.Connection.updateData(SqlDictionary.clearZombieComment);
        }

        /// <summary>
        /// 日付単位のメタコメントを削除します。
        /// </summary>
        /// <param name="date"></param>
        /// <returns></returns>
        public bool deleteDailyComment(DateComponent date)
        {
            List<object> paramList = new List<object>() { date.getDateString("yyyy-MM-dd") };
            return TaskDBConnection.Connection.updateData(SqlDictionary.clearMetaComment,paramList);
        }
        /// <summary>
        /// タスク単位でコメントを削除します。
        /// </summary>
        /// <param name="taskID"></param>
        /// <returns></returns>
        public bool deleteTaskComment(int taskID)
        {
            List<object> paramList = new List<object>() { taskID };
            return TaskDBConnection.Connection.updateData(SqlDictionary.clearTaskComment, paramList);
        }
    }
}
