﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.connection;
using System.Data.SQLite;
using com.andoutomo.kybernetes.data.DAO;


namespace com.andoutomo.kybernetes.data.accessor
{
    public class LinkDataAccessor
    {
        #region singleton
        private static LinkDataAccessor _object;
        private LinkDataAccessor() { }
        public static LinkDataAccessor getObject
        {
            get
            {
                if (_object == null)
                {
                    _object = new LinkDataAccessor();
                }
                return _object;
            }
        }
        #endregion

        public bool addLink(string linkCmd, string BaseCmd)
        {
            List<object> paramList = new List<object>();
            paramList.Add(linkCmd);
            paramList.Add(BaseCmd);

            return SettingDBConnection.Connection.updateData(CommandSqlDictionary.insertLink, paramList);
        }
        public bool removeLink(string linkCmd)
        {
            List<object> paramList = new List<object>();
            paramList.Add(linkCmd);

            return SettingDBConnection.Connection.updateData(CommandSqlDictionary.removeLink, paramList);
            
        }
        public bool hasLink(string linkCmd)
        {
            List<object> paramList = new List<object>();
            paramList.Add(linkCmd);
            bool wkRetVal = false;
            SettingDBConnection.Connection.selectData(CommandSqlDictionary.hasLink, paramList, 
                (SQLiteDataReader reader) => 
                {
                    if (reader.HasRows)
                    {
                        wkRetVal = true;
                    }
                    else
                    {
                        wkRetVal = false;
                    }
                });
            return wkRetVal;
        }
        /// <summary>
        /// リンク(アライアス)を全件取得します。
        /// </summary>
        /// <returns></returns>
        public List<SimpleDataBean> getAllLink()
        {
            List<SimpleDataBean> result = new List<SimpleDataBean>();
            SettingDBConnection.Connection.selectData(CommandSqlDictionary.getAllLink, 
                (SQLiteDataReader reader) =>
            {
                while (reader.Read())
                {
                    result.Add(new SimpleDataBean(reader["LINK_COMMAND"].ToString(), reader["BASE_COMMAND"].ToString()));
                }
            });
            return result;
        }

    }
}
