﻿using System;
using System.Collections.Generic;
using com.andoutomo.kybernetes.data.connection;
using System.Data.SQLite;
using com.andoutomo.kybernetes.control;


namespace com.andoutomo.kybernetes.data.accessor
{
    public class SettingDataAccessor
    {
        private SettingDataAccessor() { }
        private static SettingDataAccessor innerObject;
        public static SettingDataAccessor getObject
        {
            get
            {
                if (innerObject == null)
                {
                    innerObject = new SettingDataAccessor();
                }
                return innerObject;
            }
        }

        public DateComponent getToday()
        {
            DateComponent todayData = new DateComponent(DateTime.Now);
            TaskDBConnection.Connection.selectData(SqlDictionary.getToday, (SQLiteDataReader reader) =>
            {
                if (reader.HasRows)
                {
                    reader.Read();
                    todayData = new DateComponent(reader["TODAY"].ToString(), '/');
                }
            });

            return todayData;
        }
        public bool setToday(DateComponent dateComp)
        {
            List<object> arg = new List<object>();
            arg.Add(dateComp.getDateString("yyyy-MM-dd"));

            return TaskDBConnection.Connection.updateData(SqlDictionary.updateToday, arg);
        }

        public LogMode getLogMode()
        {
            LogMode retVal=LogMode.Error;
            TaskDBConnection.Connection.selectData(SqlDictionary.getLogMode,
                (SQLiteDataReader reader) =>
                {
                    if (reader.HasRows)
                    {
                        reader.Read();
                        string retStr = reader["LOGMODE"].ToString();
                        if (string.Equals(retStr.ToLower(),"trace"))
                        {
                            retVal = LogMode.Trace;
                        }
                        else if (string.Equals(retStr.ToLower(), "debug"))
                        {
                            retVal = LogMode.Debug;
                        }

                    }
                });
            return retVal;
        }

        /// <summary>
        /// ログモードをトレースに切り替えます。
        /// </summary>
        public bool changeLogModeToTrace()
        {
            return TaskDBConnection.Connection.updateData(SqlDictionary.changeTraceMode);
        }
        /// <summary>
        /// ログモードを通常モードに切り替えます。
        /// </summary>
        public bool changeLogModeToError()
        {
            return TaskDBConnection.Connection.updateData(SqlDictionary.changeErrorMode);
        }
        /// <summary>
        /// ログモードをデバッグに切り替えます。
        /// </summary>
        public bool changeLogModeToDebug()
        {
            return TaskDBConnection.Connection.updateData(SqlDictionary.changeDebugMode);
        }
        /// <summary>
        /// タイムエリア初期値を取得します。
        /// </summary>
        /// <returns></returns>
        //public string getDefaultTimeArea()
        //{
        //    string retStr = string.Empty;
        //    TaskDBConnection.Connection.selectData("SELECT DEFAULTTIMEAREA FROM TBL_SETTING",
        //        (SQLiteDataReader reader) =>
        //        {
        //            if (reader.HasRows)
        //            {
        //                reader.Read();
        //                retStr = reader["DEFAULTTIMEAREA"].ToString();
        //            }
        //        });
        //    return retStr;
        //}


    }

}
