﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.connection;


namespace com.andoutomo.kybernetes.view
{
    public partial class CategorySetting : Form
    {
        public CategorySetting()
        {
            InitializeComponent();
        }

        private Color frColor;
        private Color bgColor;
        private int categId;

        /// <summary>
        /// ダイアログを閉じると同時に、データを反映します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnClose_Click(object sender, EventArgs e)
        {
            List<MultiSQLRunnningBean> sqlList = new List<MultiSQLRunnningBean>();
            sqlList.Add(new MultiSQLRunnningBean(SqlDictionary.clearCategory,new List<object>()));
            foreach (CategoryData innerData in innerCategList)
            {
                
                List<object> argList = new List<object>();
                argList.Add(innerData.CategId);
                argList.Add(innerData.Category);
                argList.Add(innerData.FRColor);
                argList.Add(innerData.BGColor);
                sqlList.Add(new MultiSQLRunnningBean(SqlDictionary.insertCategory, argList));
            }

            TaskDBConnection.Connection.updateData(sqlList);


            this.Close();
        }

        private void btnSetFR_Click(object sender, EventArgs e)
        {
            DialogResult result = FrColorDialog.ShowDialog();
            frColor = FrColorDialog.Color;
            lblSample.ForeColor = frColor;
        }

        private void btnSetBG_Click(object sender, EventArgs e)
        {
            //DialogResult result = BgColorDialog.ShowDialog();
            //bgColor = BgColorDialog.Color;
            //lblSample.BackColor = bgColor;
            bgColor = Color.Black;
            lblSample.BackColor = Color.Black;
        }

        private List<CategoryData> innerCategList;

        /// <summary>
        /// 外部(あるいは内部)から、リストを設定します。
        /// </summary>
        /// <param name="categList"></param>
        public void setCategoryList(List<CategoryData> categList)
        {
            this.CateglistBox.Items.Clear();
            innerCategList = categList;
            foreach(CategoryData data in categList){
                this.CateglistBox.Items.Add(data.dataForDropDown.Val);
            }
        }
        /// <summary>
        /// カテゴリリストの選択を制御します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void CateglistBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (CateglistBox.SelectedItem == null) return;

            var rawdata = from data in innerCategList where data.Category == CateglistBox.SelectedItem.ToString() select data;

            foreach (CategoryData innerData in rawdata)
            {
                this.txtCategName.Text = innerData.Category;
                this.frColor = innerData.FRColorObject;
                this.bgColor = innerData.BGColorObject;
                this.categId = innerData.CategId;

                lblSample.ForeColor = frColor;
                //lblSample.BackColor = bgColor;
            }

        }
        /// <summary>
        /// カテゴリを追加します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAdd_Click(object sender, EventArgs e)
        {
            if (this.txtCategName.Text == string.Empty) return;

            var rawdata = from data in innerCategList where data.Category == this.txtCategName.Text select data;

            foreach (CategoryData dummy in rawdata)
            {
                //既にデータがある場合は何もせず終了
                return;
            }

            CategoryData insertData = new CategoryData();
            insertData.Category = this.txtCategName.Text;
            insertData.FRColor = this.frColor.ToArgb();
            //insertData.BGColor = this.bgColor.ToArgb();

            var nextid = 0;
            
            if (CateglistBox.Items.Count > 0)
            {
                nextid = (from data in innerCategList select data.CategId).Max();
            }

            insertData.CategId = ((int)nextid) + 1;
            innerCategList.Add(insertData);
            setCategoryList(innerCategList);

            txtCategName.Clear();
        }

        /// <summary>
        /// カテゴリを変更します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnApply_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(this.txtCategName.Text))
            {
                if (this.categId == 0) { return; }
            }
            var rawdata = from data in innerCategList where data.CategId == this.categId select data;
            foreach (CategoryData updData in rawdata)
            {
                if (string.IsNullOrEmpty(this.txtCategName.Text))
                {
                    innerCategList.Remove(updData);
                    break;
                }
                else
                {
                    updData.Category = this.txtCategName.Text;
                    updData.FRColor = this.frColor.ToArgb();
              //      updData.BGColor = this.bgColor.ToArgb();
                }
            }
            setCategoryList(innerCategList);
        }
    }
}
