﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.view
{
    public partial class DropBoxInputBox : Form
    {
        public DropBoxInputBox()
        {
            InitializeComponent();
        }
        public DropBoxInputBox(string prompt)
            : this()
        {
            this.lblTitle.Text = prompt;
        }
        public DropBoxInputBox(string prompt, string defaultData)
            : this(prompt)
        {
            this.cmbSelect.Text = defaultData;
        }

        List<SimpleDataBean> beanList;

        public void setDropData(List<SimpleDataBean> _beanList)
        {
            this.beanList = _beanList;
            //既に設定されている場合は一旦退避
            string defaultData = cmbSelect.Text;

            cmbSelect.Items.Clear();

            foreach (SimpleDataBean bean in beanList)
            {
                cmbSelect.Items.Add(bean.Val);
            }
            cmbSelect.Text = defaultData;
        }


        private void turnCollect()
        {
            this.DialogResult = DialogResult.OK;
            ((BaseForm)Owner).InputDialogData = cmbSelect.Text;
            this.Close();
        }

        private void turnCancel()
        {
            this.DialogResult = DialogResult.Cancel;
            ((BaseForm)Owner).InputDialogData = string.Empty;
            this.Close();
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            turnCollect();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            turnCancel();
        }
    }
}
